/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.resolver;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolverDescriptor;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolverService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ObjectResolverServiceImpl
extends DefaultComponent
implements ObjectResolverService {
    private static final Log log = LogFactory.getLog(ObjectResolverServiceImpl.class);
    private Map<String, Class<? extends ObjectResolver>> resolvers;

    public void activate(ComponentContext context) {
        super.activate(context);
        this.resolvers = new HashMap<String, Class<? extends ObjectResolver>>();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("resolvers")) {
            ObjectResolverDescriptor erd = (ObjectResolverDescriptor)contribution;
            this.resolvers.put(erd.getType(), erd.getResolver());
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("resolvers")) {
            ObjectResolverDescriptor erd = (ObjectResolverDescriptor)contribution;
            this.resolvers.remove(erd.getType());
        }
    }

    @Override
    public ObjectResolver getResolver(String type, Map<String, String> parameters) {
        Class<? extends ObjectResolver> resolverClass = this.resolvers.get(type);
        if (resolverClass == null) {
            return null;
        }
        ObjectResolver resolver = null;
        try {
            resolver = resolverClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.warn((Object)String.format("Unable to instanciate %s - missing public constructor with no param", resolverClass.getCanonicalName()));
            return null;
        }
        try {
            resolver.configure(parameters != null ? parameters : new HashMap());
        }
        catch (IllegalArgumentException e) {
            log.info((Object)String.format("Unable to configure %s with parameters %s", resolverClass.getCanonicalName(), ((Object)parameters).toString()));
            return null;
        }
        return resolver;
    }
}

