/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.download;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.test.runner.RuntimeFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={RuntimeFeature.class})
@Deploy(value={"org.nuxeo.ecm.core.io"})
@LocalDeploy(value={"org.nuxeo.ecm.core.io.test:OSGI-INF/test-download-service-with-resolver.xml"})
public class TestCustomRedirectResolver {
    @Inject
    protected DownloadService downloadService;

    @Test
    public void testRedirectResolver() throws IOException {
        Blob blob = Blobs.createBlob((String)"Whatever");
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        ServletOutputStream sos = new ServletOutputStream(){

            public void write(int b) throws IOException {
                out.write(b);
            }
        };
        PrintWriter printWriter = new PrintWriter((OutputStream)sos);
        Mockito.when((Object)response.getOutputStream()).thenReturn((Object)sos);
        Mockito.when((Object)response.getWriter()).thenReturn((Object)printWriter);
        this.downloadService.downloadBlob(request, response, null, null, blob, null, null);
        ((HttpServletResponse)Mockito.verify((Object)response)).sendRedirect((String)Matchers.eq((Object)"http://www.nuxeo.org"));
        Assert.assertEquals((Object)"", (Object)out.toString());
    }
}

