/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.download;

import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.core.io.download.DownloadHelper;
import org.nuxeo.ecm.core.io.download.DownloadService;

public class TestDownloadHelper {
    @Test
    public void testParseByteRange() throws Exception {
        DownloadService.ByteRange byteRange = DownloadHelper.parseRange((String)"bytes=42-169", (long)12345L);
        Assert.assertEquals((long)42L, (long)byteRange.getStart());
        Assert.assertEquals((long)169L, (long)byteRange.getEnd());
        Assert.assertEquals((long)128L, (long)byteRange.getLength());
    }

    @Test
    public void testParseByteRangeWithoutEnd() throws Exception {
        DownloadService.ByteRange byteRange = DownloadHelper.parseRange((String)"bytes=0-", (long)12345L);
        Assert.assertEquals((long)0L, (long)byteRange.getStart());
        Assert.assertEquals((long)12344L, (long)byteRange.getEnd());
        Assert.assertEquals((long)12345L, (long)byteRange.getLength());
    }

    @Test
    public void testParseByteRangeWithoutStart() throws Exception {
        DownloadService.ByteRange byteRange = DownloadHelper.parseRange((String)"bytes=-128", (long)12345L);
        Assert.assertEquals((long)12217L, (long)byteRange.getStart());
        Assert.assertEquals((long)12344L, (long)byteRange.getEnd());
        Assert.assertEquals((long)128L, (long)byteRange.getLength());
    }

    @Test
    public void testParseUnsupportedByteRange() throws Exception {
        Assert.assertNull((Object)DownloadHelper.parseRange((String)"blablabla", (long)12345L));
    }

    @Test
    public void testParseUnsupportedByteRange2() throws Exception {
        Assert.assertNull((Object)DownloadHelper.parseRange((String)"bytes=", (long)12345L));
    }

    @Test
    public void testParseUnsupportedByteRange3() throws Exception {
        Assert.assertNull((Object)DownloadHelper.parseRange((String)"bytes=-", (long)12345L));
    }

    @Test
    public void testParseUnsupportedByteRange4() throws Exception {
        Assert.assertNull((Object)DownloadHelper.parseRange((String)"bytes=123-45", (long)12345L));
    }

    @Test
    public void testParseUnsupportedByteRange5() throws Exception {
        Assert.assertNull((Object)DownloadHelper.parseRange((String)"bytes=0-123,-45", (long)12345L));
    }

    @Test
    public void testParseUnsupportedByteRange6() throws Exception {
        Assert.assertNull((Object)DownloadHelper.parseRange((String)"bytes=foo-bar", (long)12345L));
    }
}

