/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.download;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.core.api.local.LoginStack;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.test.runner.RuntimeFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={RuntimeFeature.class})
@Deploy(value={"org.nuxeo.ecm.core.io"})
@LocalDeploy(value={"org.nuxeo.ecm.core.io.test:OSGI-INF/test-download-service.xml"})
public class TestDownloadService {
    @Inject
    protected DownloadService downloadService;

    @Test
    public void testBasicDownload() throws Exception {
        String blobValue = "Hello World";
        Blob blob = Blobs.createBlob((String)blobValue);
        blob.setFilename("myFile.txt");
        blob.setDigest("12345");
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        ServletOutputStream sos = new ServletOutputStream(){

            public void write(int b) throws IOException {
                out.write(b);
            }
        };
        PrintWriter printWriter = new PrintWriter((OutputStream)sos);
        Mockito.when((Object)response.getOutputStream()).thenReturn((Object)sos);
        Mockito.when((Object)response.getWriter()).thenReturn((Object)printWriter);
        this.downloadService.downloadBlob(request, response, null, null, blob, null, null);
        Assert.assertEquals((Object)blobValue, (Object)out.toString());
    }

    @Test
    public void testETagHeaderNone() throws Exception {
        this.doTestETagHeader(null);
    }

    @Test
    public void testETagHeaderNotMatched() throws Exception {
        this.doTestETagHeader(Boolean.FALSE);
    }

    @Test
    public void testETagHeaderMatched() throws Exception {
        this.doTestETagHeader(Boolean.TRUE);
    }

    protected void doTestETagHeader(Boolean match) throws Exception {
        String blobValue = "Hello World";
        Blob blob = Blobs.createBlob((String)blobValue);
        blob.setFilename("myFile.txt");
        blob.setDigest("12345");
        String digestToTest = match == null ? null : (Boolean.TRUE.equals(match) ? "12345" : "78787");
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getHeader("If-None-Match")).thenReturn((Object)('\"' + digestToTest + '\"'));
        Mockito.when((Object)req.getMethod()).thenReturn((Object)"GET");
        HttpServletResponse resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        ServletOutputStream sos = new ServletOutputStream(){

            public void write(int b) throws IOException {
                out.write(b);
            }
        };
        PrintWriter printWriter = new PrintWriter((OutputStream)sos);
        Mockito.when((Object)resp.getOutputStream()).thenReturn((Object)sos);
        Mockito.when((Object)resp.getWriter()).thenReturn((Object)printWriter);
        this.downloadService.downloadBlob(req, resp, null, null, blob, null, null);
        ((HttpServletRequest)Mockito.verify((Object)req, (VerificationMode)Mockito.atLeast((int)1))).getHeader("If-None-Match");
        if (Boolean.TRUE.equals(match)) {
            Assert.assertEquals((long)0L, (long)out.toByteArray().length);
            ((HttpServletResponse)Mockito.verify((Object)resp)).sendError(304);
        } else {
            Assert.assertEquals((Object)blobValue, (Object)out.toString());
            ((HttpServletResponse)Mockito.verify((Object)resp)).setHeader("ETag", '\"' + blob.getDigest() + '\"');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDownloadPermission() throws Exception {
        String blobValue = "Hello World";
        Blob blob = Blobs.createBlob((String)blobValue);
        blob.setFilename("myfile.txt");
        blob.setDigest("12345");
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        ServletOutputStream sos = new ServletOutputStream(){

            public void write(int b) throws IOException {
                out.write(b);
            }
        };
        PrintWriter printWriter = new PrintWriter((OutputStream)sos);
        Mockito.when((Object)response.getOutputStream()).thenReturn((Object)sos);
        Mockito.when((Object)response.getWriter()).thenReturn((Object)printWriter);
        DocumentModel doc = (DocumentModel)Mockito.mock(DocumentModel.class);
        Mockito.when((Object)doc.getPropertyValue("dc:format")).thenReturn((Object)"pdf");
        String reason = "rendition";
        Map<String, String> extendedInfos = Collections.singletonMap("rendition", "myrendition");
        UserPrincipal principal = new UserPrincipal("bob", Collections.singletonList("members"), false, false);
        LoginStack loginStack = ClientLoginModule.getThreadLocalLogin();
        loginStack.push((Principal)principal, null, null);
        try {
            this.downloadService.downloadBlob(request, response, doc, "file:content", blob, null, reason, extendedInfos);
            Assert.assertEquals((Object)"", (Object)out.toString());
            ((HttpServletResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.atLeastOnce())).sendError(403, "Permission denied");
            this.downloadService.downloadBlob(request, response, doc, "other:blob", blob, null, reason, extendedInfos);
            Assert.assertEquals((Object)blobValue, (Object)out.toString());
        }
        finally {
            loginStack.pop();
        }
    }
}

