/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.test.DefaultRepositoryInit;

public class ComplexDocRepositoryInit
extends DefaultRepositoryInit {
    public static final String TEST_DOC_NAME = "testDoc";

    public void populate(CoreSession session) {
        this.createTestDoc(session);
    }

    protected final DocumentModel createTestDoc(CoreSession session) {
        DocumentModel doc = session.createDocumentModel("/", TEST_DOC_NAME, "CSDoc");
        doc.setProperty("dublincore", "title", (Object)"My test doc");
        doc.setProperty("dublincore", "created", (Object)"2011-12-29T11:24:25Z");
        doc.setProperty("dublincore", "creator", (Object)"Administrator");
        doc.setProperty("dublincore", "modified", (Object)"2011-12-29T11:24:25Z");
        doc.setProperty("dublincore", "lastContributor", (Object)"Administrator");
        doc.setProperty("dublincore", "contributors", (Object)new String[]{"Administrator", "Joe"});
        doc.setProperty("dublincore", "subjects", (Object)new String[]{"Art", "Architecture"});
        doc.setProperty("file", "filename", (Object)"test_file.doc");
        Blob blob = Blobs.createBlob((String)"My blob");
        blob.setFilename("test_file.doc");
        doc.setProperty("file", "content", (Object)blob);
        doc.setPropertyValue("cs:currentVersion", (Serializable)((Object)"V1"));
        doc.setPropertyValue("cs:modelType", (Serializable)((Object)"Insurance"));
        doc.setPropertyValue("cs:origin", (Serializable)((Object)"Internal"));
        HashMap<String, Object> segment = new HashMap<String, Object>();
        segment.put("name", "MySegment");
        segment.put("target", "SomeTarget");
        segment.put("variableType", "rawVariable");
        List<String> roles = Arrays.asList("Score", "ComparisonScore", "Decision");
        segment.put("roles", (Serializable)((Object)roles));
        doc.setPropertyValue("cs:segmentVariable", (Serializable)segment);
        doc = session.createDocument(doc);
        ACP acp = doc.getACP();
        acp.addACE("local", new ACE("leela", "Read"));
        GregorianCalendar begin = new GregorianCalendar(2000, 10, 10);
        GregorianCalendar end = new GregorianCalendar(2010, 10, 10);
        acp.addACE("local", ACE.builder((String)"fry", (String)"Write").creator("leela").begin((Calendar)begin).end((Calendar)end).build());
        doc.setACP(acp, true);
        return doc;
    }
}

