/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl;

import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.ExportedDocumentImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
@RepositoryConfig(cleanup=Granularity.METHOD)
public class TestExportImportBlob {
    @Inject
    protected CoreSession session;
    DocumentModel rootDocument;
    DocumentModel workspace;
    DocumentModel docToExport;

    private void createDocs() throws Exception {
        this.rootDocument = this.session.getRootDocument();
        this.workspace = this.session.createDocumentModel(this.rootDocument.getPathAsString(), "ws1", "Workspace");
        this.workspace.setProperty("dublincore", "title", (Object)"test WS");
        this.workspace = this.session.createDocument(this.workspace);
        this.docToExport = this.session.createDocumentModel(this.workspace.getPathAsString(), "file", "File");
        this.docToExport.setProperty("dublincore", "title", (Object)"MyDoc");
        Blob blob = Blobs.createBlob((String)"SomeDummyContent");
        blob.setFilename("dummyBlob.txt");
        this.docToExport.setProperty("file", "content", (Object)blob);
        this.docToExport = this.session.createDocument(this.docToExport);
        this.session.save();
    }

    @Test
    public void testBlobFilenamePresent() throws Exception {
        this.createDocs();
        ExportedDocumentImpl exportedDoc = new ExportedDocumentImpl(this.docToExport, true);
        Assert.assertEquals((Object)"File", (Object)exportedDoc.getType());
        this.session.removeDocument(this.docToExport.getRef());
        this.session.save();
        Assert.assertEquals((long)0L, (long)this.session.getChildren(this.workspace.getRef()).size());
        DocumentModelWriter writer = new DocumentModelWriter(this.session, this.rootDocument.getPathAsString());
        writer.write((ExportedDocument)exportedDoc);
        DocumentModelList children = this.session.getChildren(this.workspace.getRef());
        Assert.assertEquals((long)1L, (long)children.size());
        DocumentModel importedDocument = (DocumentModel)children.get(0);
        Blob blob = (Blob)importedDocument.getProperty("file", "content");
        Assert.assertEquals((Object)"dummyBlob.txt", (Object)blob.getFilename());
    }
}

