/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl;

import java.io.File;
import java.io.FileInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentTreeReader;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveReader;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveWriter;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
@RepositoryConfig(cleanup=Granularity.METHOD)
public class TestExportImportZipArchive {
    @Inject
    protected CoreSession session;
    DocumentModel rootDocument;
    DocumentModel workspace;
    DocumentModel docToExport;
    protected static final String XML_DATA = "\n    <nxdt:templateParams xmlns:nxdt=\"http://www.nuxeo.org/DocumentTemplate\">\n<nxdt:field name=\"htmlContent\" type=\"content\" source=\"htmlPreview\"></nxdt:field>\n   </nxdt:templateParams>\n    ";

    private void createDocs() throws Exception {
        this.rootDocument = this.session.getRootDocument();
        this.workspace = this.session.createDocumentModel(this.rootDocument.getPathAsString(), "ws1", "Workspace");
        this.workspace.setProperty("dublincore", "title", (Object)"test WS");
        this.workspace = this.session.createDocument(this.workspace);
        this.docToExport = this.session.createDocumentModel(this.workspace.getPathAsString(), "file", "File");
        this.docToExport.setProperty("dublincore", "title", (Object)"MyDoc");
        this.docToExport.setProperty("dublincore", "description", (Object)XML_DATA);
        Blob blob = Blobs.createBlob((String)"SomeDummyContent");
        blob.setFilename("dummyBlob.txt");
        this.docToExport.setProperty("file", "content", (Object)blob);
        this.docToExport = this.session.createDocument(this.docToExport);
        this.docToExport.addFacet("HiddenInNavigation");
        this.docToExport = this.session.saveDocument(this.docToExport);
        this.session.save();
    }

    @Test
    public void testExportAsZipAndReimport() throws Exception {
        this.createDocs();
        File archive = Framework.createTempFile((String)"core-io-archive", (String)"zip");
        DocumentTreeReader reader = new DocumentTreeReader(this.session, this.workspace);
        NuxeoArchiveWriter writer = new NuxeoArchiveWriter(archive);
        DocumentPipeImpl pipe = new DocumentPipeImpl(10);
        pipe.setReader((DocumentReader)reader);
        pipe.setWriter((DocumentWriter)writer);
        pipe.run();
        Assert.assertTrue((boolean)archive.exists());
        Assert.assertTrue((archive.length() > 0L ? 1 : 0) != 0);
        writer.close();
        reader.close();
        ZipInputStream zin = new ZipInputStream(new FileInputStream(archive));
        ZipEntry entry = zin.getNextEntry();
        int nbDocs = 0;
        int nbBlobs = 0;
        while (entry != null) {
            if (entry.getName().endsWith("document.xml")) {
                ++nbDocs;
            } else if (entry.getName().endsWith(".blob")) {
                ++nbBlobs;
            }
            entry = zin.getNextEntry();
        }
        Assert.assertEquals((long)2L, (long)nbDocs);
        Assert.assertEquals((long)1L, (long)nbBlobs);
        ((EventService)Framework.getService(EventService.class)).waitForAsyncCompletion();
        this.session.removeDocument(this.workspace.getRef());
        this.session.save();
        Assert.assertEquals((long)0L, (long)this.session.getChildren(this.session.getRootDocument().getRef()).size());
        reader = new NuxeoArchiveReader(archive);
        writer = new DocumentModelWriter(this.session, "/");
        pipe = new DocumentPipeImpl(10);
        pipe.setReader((DocumentReader)reader);
        pipe.setWriter((DocumentWriter)writer);
        pipe.run();
        archive.delete();
        DocumentModelList children = this.session.getChildren(this.session.getRootDocument().getRef());
        Assert.assertEquals((long)1L, (long)children.size());
        DocumentModel importedWS = (DocumentModel)children.get(0);
        Assert.assertEquals((Object)this.workspace.getTitle(), (Object)importedWS.getTitle());
        children = this.session.getChildren(importedWS.getRef());
        DocumentModel importedDocument = (DocumentModel)children.get(0);
        Blob blob = (Blob)importedDocument.getProperty("file", "content");
        Assert.assertEquals((Object)"dummyBlob.txt", (Object)blob.getFilename());
        Assert.assertEquals((Object)"MyDoc", (Object)importedDocument.getPropertyValue("dc:title"));
        Assert.assertEquals((Object)XML_DATA, (Object)importedDocument.getPropertyValue("dc:description"));
        Assert.assertTrue((boolean)importedDocument.hasFacet("HiddenInNavigation"));
    }
}

