/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.dom4j.io.XMLWriter;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.ExportedDocumentImpl;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveReader;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveWriter;
import org.nuxeo.runtime.test.NXRuntimeTestCase;

public class TestExportedDocument
extends NXRuntimeTestCase {
    @Test
    public void testExportedDocument() throws Exception {
        final DocumentModel model = (DocumentModel)this.jmcontext.mock(DocumentModel.class);
        this.jmcontext.checking((ExpectationBuilder)new Expectations(){
            {
                ((DocumentModel)this.atLeast(1).of((Object)model)).getId();
                this.will(1.returnValue((Object)"My id"));
                ((DocumentModel)this.atLeast(1).of((Object)model)).getType();
                this.will(1.returnValue((Object)"My type"));
                ((DocumentModel)this.atLeast(1).of((Object)model)).getRef();
                this.will(1.returnValue((Object)new IdRef("My id")));
                ((DocumentModel)this.atLeast(1).of((Object)model)).getName();
                this.will(1.returnValue(null));
                ((DocumentModel)this.atLeast(1).of((Object)model)).getCurrentLifeCycleState();
                this.will(1.returnValue(null));
                ((DocumentModel)this.atLeast(1).of((Object)model)).getLifeCyclePolicy();
                this.will(1.returnValue(null));
                ((DocumentModel)this.atLeast(1).of((Object)model)).getACP();
                this.will(1.returnValue(null));
                ((DocumentModel)this.atLeast(1).of((Object)model)).getSchemas();
                this.will(1.returnValue((Object)new String[0]));
                ((DocumentModel)this.atLeast(1).of((Object)model)).getRepositoryName();
                this.will(1.returnValue(null));
                ((DocumentModel)this.atLeast(1).of((Object)model)).getPath();
                this.will(1.returnValue((Object)new Path("my-path")));
                ((DocumentModel)this.atLeast(1).of((Object)model)).getPathAsString();
                this.will(1.returnValue((Object)"/my/path/"));
                ((DocumentModel)this.atLeast(1).of((Object)model)).getFacets();
            }
        });
        ExportedDocumentImpl exportedDoc = new ExportedDocumentImpl(model);
        Assert.assertEquals((Object)"My id", (Object)exportedDoc.getId());
        Assert.assertEquals((Object)"My type", (Object)exportedDoc.getType());
        Assert.assertEquals((Object)"my-path", (Object)exportedDoc.getPath().toString());
        StringWriter writer = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)writer);
        xmlWriter.write(exportedDoc.getDocument());
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<document id=\"My id\"><system><type>My type</type><path>my-path</path><access-control/></system></document>", (Object)((Object)writer).toString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        NuxeoArchiveWriter archWriter = new NuxeoArchiveWriter((OutputStream)out);
        archWriter.write((ExportedDocument)exportedDoc);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        NuxeoArchiveReader archReader = new NuxeoArchiveReader((InputStream)in);
        ExportedDocument newExportedDoc = archReader.read();
        Assert.assertEquals((Object)exportedDoc.getId(), (Object)newExportedDoc.getId());
        Assert.assertEquals((Object)exportedDoc.getPath(), (Object)newExportedDoc.getPath());
        Assert.assertEquals((Object)exportedDoc.getType(), (Object)newExportedDoc.getType());
    }
}

