/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl;

import java.io.File;
import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.impl.ComplexDocRepositoryInit;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveReader;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveWriter;
import org.nuxeo.ecm.core.io.impl.plugins.SingleDocumentReader;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
@RepositoryConfig(init=ComplexDocRepositoryInit.class)
@Deploy(value={"org.nuxeo.ecm.core.io"})
@LocalDeploy(value={"org.nuxeo.ecm.core.io:OSGI-INF/doc-type-contrib.xml"})
public class TestImportExportWithComplexXSD {
    @Inject
    protected CoreSession session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void checkComplexTypeExportImport() throws Exception {
        DocumentModel doc = this.session.getDocument((DocumentRef)new PathRef("/testDoc"));
        Assert.assertNotNull((Object)doc);
        this.verifyProperties(doc);
        File out = Framework.createTempFile((String)"model-io", (String)".zip");
        SingleDocumentReader reader = new SingleDocumentReader(this.session, doc);
        NuxeoArchiveWriter writer = new NuxeoArchiveWriter(out);
        try {
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            pipe.setReader((DocumentReader)reader);
            pipe.setWriter((DocumentWriter)writer);
            pipe.run();
        }
        finally {
            writer.close();
            reader.close();
        }
        Assert.assertTrue((out.length() > 0L ? 1 : 0) != 0);
        DocumentModel newParent = this.session.createDocumentModel("/", "importRoot", "Folder");
        newParent.setPropertyValue("dc:title", (Serializable)((Object)"Import Root"));
        newParent = this.session.createDocument(newParent);
        this.session.save();
        reader = new NuxeoArchiveReader(out);
        writer = new DocumentModelWriter(this.session, newParent.getPathAsString());
        try {
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            pipe.setReader((DocumentReader)reader);
            pipe.setWriter((DocumentWriter)writer);
            pipe.run();
        }
        finally {
            writer.close();
            reader.close();
            out.delete();
        }
        DocumentModelList children = this.session.getChildren(newParent.getRef());
        Assert.assertEquals((long)1L, (long)children.totalSize());
        this.verifyProperties((DocumentModel)children.get(0));
    }

    protected void verifyProperties(DocumentModel doc) throws Exception {
        Assert.assertEquals((Object)"Insurance", (Object)doc.getPropertyValue("cs:modelType"));
        Assert.assertEquals((Object)"V1", (Object)doc.getPropertyValue("cs:currentVersion"));
        Assert.assertEquals((Object)"Internal", (Object)doc.getPropertyValue("cs:origin"));
        Map segment = (Map)((Object)doc.getPropertyValue("cs:segmentVariable"));
        Assert.assertEquals((Object)"MySegment", segment.get("name"));
        Assert.assertEquals((Object)"SomeTarget", segment.get("target"));
        Assert.assertEquals((Object)"rawVariable", segment.get("variableType"));
        Assert.assertNull(segment.get("dataType"));
        List roles = (List)segment.get("roles");
        Assert.assertEquals((long)3L, (long)roles.size());
        Assert.assertTrue((boolean)roles.contains("Score"));
        Assert.assertTrue((boolean)roles.contains("ComparisonScore"));
        Assert.assertTrue((boolean)roles.contains("Decision"));
        ACP acp = doc.getACP();
        Assert.assertNotNull((Object)acp);
        ACL acl = acp.getACL("local");
        Assert.assertEquals((long)2L, (long)acl.size());
        ACE ace = (ACE)acl.get(0);
        Assert.assertEquals((Object)"leela", (Object)ace.getUsername());
        Assert.assertEquals((Object)"Read", (Object)ace.getPermission());
        Assert.assertNull((Object)ace.getCreator());
        Assert.assertNull((Object)ace.getBegin());
        Assert.assertNull((Object)ace.getEnd());
        ace = (ACE)acl.get(1);
        Assert.assertEquals((Object)"fry", (Object)ace.getUsername());
        Assert.assertEquals((Object)"Write", (Object)ace.getPermission());
        Assert.assertEquals((Object)"leela", (Object)ace.getCreator());
        Calendar begin = ace.getBegin();
        Assert.assertNotNull((Object)begin);
        GregorianCalendar expectedBegin = new GregorianCalendar(2000, 10, 10);
        Assert.assertEquals((Object)expectedBegin, (Object)begin);
        Calendar end = ace.getEnd();
        Assert.assertNotNull((Object)end);
        GregorianCalendar expectedEnd = new GregorianCalendar(2010, 10, 10);
        Assert.assertEquals((Object)expectedEnd, (Object)end);
    }
}

