/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl;

import java.io.File;
import java.io.InputStream;
import java.security.MessageDigest;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.common.utils.Base64;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveReader;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
@RepositoryConfig(cleanup=Granularity.METHOD)
public class TestImportModifiedZipArchive {
    @Inject
    protected CoreSession session;
    DocumentModel rootDocument;
    DocumentModel workspace;
    DocumentModel docToExport;

    @Test
    public void testImportUnModifiedArchive() throws Exception {
        File archive = FileUtils.getResourceFileFromContext((String)"archive.zip");
        NuxeoArchiveReader reader = new NuxeoArchiveReader(archive);
        DocumentModelWriter writer = new DocumentModelWriter(this.session, "/");
        DocumentPipeImpl pipe = new DocumentPipeImpl(10);
        pipe.setReader((DocumentReader)reader);
        pipe.setWriter((DocumentWriter)writer);
        pipe.run();
        DocumentModelList children = this.session.getChildren(this.session.getRootDocument().getRef());
        Assert.assertEquals((long)1L, (long)children.size());
        DocumentModel importedWS = (DocumentModel)children.get(0);
        Assert.assertEquals((Object)"test WS", (Object)importedWS.getTitle());
        children = this.session.getChildren(importedWS.getRef());
        DocumentModel importedDocument = (DocumentModel)children.get(0);
        Blob blob = (Blob)importedDocument.getProperty("file", "content");
        Assert.assertEquals((Object)"dummyBlob.txt", (Object)blob.getFilename());
        Assert.assertEquals((Object)"SomeDummyContent", (Object)blob.getString());
        byte[] expected = MessageDigest.getInstance("MD5").digest("SomeDummyContent".getBytes());
        String source = Base64.encodeBytes((byte[])expected);
        byte[] actual = MessageDigest.getInstance("MD5").digest(FileUtils.readBytes((InputStream)blob.getStream()));
        String result = Base64.encodeBytes((byte[])actual);
        Assert.assertEquals((Object)source, (Object)result);
    }

    @Test
    public void testImportModifiedArchive() throws Exception {
        File archive = FileUtils.getResourceFileFromContext((String)"modified_archive.zip");
        NuxeoArchiveReader reader = new NuxeoArchiveReader(archive);
        DocumentModelWriter writer = new DocumentModelWriter(this.session, "/");
        DocumentPipeImpl pipe = new DocumentPipeImpl(10);
        pipe.setReader((DocumentReader)reader);
        pipe.setWriter((DocumentWriter)writer);
        pipe.run();
        DocumentModelList children = this.session.getChildren(this.session.getRootDocument().getRef());
        Assert.assertEquals((long)1L, (long)children.size());
        DocumentModel importedWS = (DocumentModel)children.get(0);
        Assert.assertEquals((Object)"test WS (imported)", (Object)importedWS.getTitle());
        children = this.session.getChildren(importedWS.getRef());
        DocumentModel importedDocument = (DocumentModel)children.get(0);
        Blob blob = (Blob)importedDocument.getProperty("file", "content");
        Assert.assertEquals((Object)"dummyBlob.txt", (Object)blob.getFilename());
        Assert.assertEquals((Object)"SomeDummyContentImported\n", (Object)blob.getString());
    }

    @Test
    public void testImportModifiedArchiveWithNewItems() throws Exception {
        File archive = FileUtils.getResourceFileFromContext((String)"modified_archive2.zip");
        NuxeoArchiveReader reader = new NuxeoArchiveReader(archive);
        DocumentModelWriter writer = new DocumentModelWriter(this.session, "/");
        DocumentPipeImpl pipe = new DocumentPipeImpl(10);
        pipe.setReader((DocumentReader)reader);
        pipe.setWriter((DocumentWriter)writer);
        pipe.run();
        DocumentModelList children = this.session.getChildren(this.session.getRootDocument().getRef());
        Assert.assertEquals((long)1L, (long)children.size());
        DocumentModel importedWS = (DocumentModel)children.get(0);
        Assert.assertEquals((Object)"test WS (imported)", (Object)importedWS.getTitle());
        children = this.session.getChildren(importedWS.getRef());
        Assert.assertEquals((long)2L, (long)children.size());
        children = this.session.getChildren(importedWS.getRef(), "File");
        Assert.assertEquals((long)1L, (long)children.size());
        DocumentModel importedDocument = (DocumentModel)children.get(0);
        Blob blob = (Blob)importedDocument.getProperty("file", "content");
        Assert.assertEquals((Object)"dummyBlob.txt", (Object)blob.getFilename());
        Assert.assertEquals((Object)"SomeDummyContentImported\n", (Object)blob.getString());
        children = this.session.getChildren(importedWS.getRef(), "Folder");
        Assert.assertEquals((long)1L, (long)children.size());
        DocumentModel newFolder = (DocumentModel)children.get(0);
        Assert.assertEquals((Object)"subfolder created from import", (Object)newFolder.getTitle());
        children = this.session.getChildren(newFolder.getRef(), "File");
        Assert.assertEquals((long)1L, (long)children.size());
        DocumentModel createdDocument = (DocumentModel)children.get(0);
        Assert.assertEquals((Object)"Created File", (Object)createdDocument.getTitle());
        blob = (Blob)createdDocument.getProperty("file", "content");
        Assert.assertEquals((Object)"newBlob.txt", (Object)blob.getFilename());
        Assert.assertEquals((Object)"NewContent\n", (Object)blob.getString());
    }

    @Test
    public void testImportContentTemplateArchive() throws Exception {
        File archive = FileUtils.getResourceFileFromContext((String)"export.zip");
        NuxeoArchiveReader reader = new NuxeoArchiveReader(archive);
        DocumentModelWriter writer = new DocumentModelWriter(this.session, "/");
        DocumentPipeImpl pipe = new DocumentPipeImpl(10);
        pipe.setReader((DocumentReader)reader);
        pipe.setWriter((DocumentWriter)writer);
        pipe.run();
        this.session.save();
        StringBuffer sb = new StringBuffer();
        DocumentModelList docs = this.session.query("select * from Document order by ecm:path");
        for (DocumentModel doc : docs) {
            sb.append(doc.getPathAsString() + " - " + doc.getType() + " -- " + doc.getTitle());
            sb.append("\n");
        }
        String dump = sb.toString();
        Assert.assertTrue((boolean)dump.contains("testZipImport - Folder"));
        Assert.assertTrue((boolean)dump.contains("hello file - File"));
        Assert.assertTrue((boolean)dump.contains("HelloNote - Note"));
        Assert.assertTrue((boolean)dump.contains("SubFolder - Folder"));
        Assert.assertTrue((boolean)dump.contains("SubNote - Note"));
    }
}

