/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl;

import java.util.Iterator;
import javax.inject.Inject;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.io.DocumentSource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.io.impl.TypedExportedDocumentImpl;
import org.nuxeo.ecm.core.io.impl.TypedExportedDocumentRepositoryInit;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.w3c.dom.Node;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
@RepositoryConfig(init=TypedExportedDocumentRepositoryInit.class, cleanup=Granularity.METHOD)
public class TestTypedExportedDocument {
    protected static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    @Inject
    protected CoreSession session;

    @Test
    public void testTypedExportedDocument() throws Exception {
        DocumentModel doc = this.session.getDocument((DocumentRef)new PathRef("/testDoc"));
        TypedExportedDocumentImpl exportedDoc = new TypedExportedDocumentImpl(doc);
        Assert.assertEquals((Object)"File", (Object)exportedDoc.getType());
        Assert.assertEquals((Object)"testDoc", (Object)exportedDoc.getPath().toString());
        Document dom4jDocument = exportedDoc.getDocument();
        org.w3c.dom.Document document = this.dom4jToW3c(dom4jDocument);
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new CoreNamespaceContext());
        Node schemaNode = (Node)xpath.evaluate("//schema[@name='dublincore']", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)schemaNode);
        Node fieldNode = (Node)xpath.evaluate("//dc:title[@type='string']", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)fieldNode);
        Assert.assertEquals((Object)"My test doc", (Object)fieldNode.getTextContent());
        fieldNode = (Node)xpath.evaluate("//dc:created[@type='date']", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)fieldNode);
        Assert.assertEquals((Object)"2011-12-29T11:24:25.00Z", (Object)fieldNode.getTextContent());
        fieldNode = (Node)xpath.evaluate("//dc:creator[@type='string']", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)fieldNode);
        Assert.assertEquals((Object)"Administrator", (Object)fieldNode.getTextContent());
        fieldNode = (Node)xpath.evaluate("//dc:modified[@type='date']", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)fieldNode);
        Assert.assertEquals((Object)"2011-12-29T11:24:25.00Z", (Object)fieldNode.getTextContent());
        fieldNode = (Node)xpath.evaluate("//dc:lastContributor[@type='string']", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)fieldNode);
        Assert.assertEquals((Object)"Administrator", (Object)fieldNode.getTextContent());
        fieldNode = (Node)xpath.evaluate("//dc:contributors[@type='scalarList']", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)fieldNode);
        fieldNode = (Node)xpath.evaluate("//dc:contributors[@type='scalarList']/item[1]", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)fieldNode);
        Assert.assertEquals((Object)"Administrator", (Object)fieldNode.getTextContent());
        fieldNode = (Node)xpath.evaluate("//dc:contributors[@type='scalarList']/item[2]", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)fieldNode);
        Assert.assertEquals((Object)"Joe", (Object)fieldNode.getTextContent());
        fieldNode = (Node)xpath.evaluate("//dc:subjects[@type='scalarList']", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)fieldNode);
        fieldNode = (Node)xpath.evaluate("//dc:subjects[@type='scalarList']/item[1]", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)fieldNode);
        Assert.assertEquals((Object)"Art", (Object)fieldNode.getTextContent());
        fieldNode = (Node)xpath.evaluate("//dc:subjects[@type='scalarList']/item[2]", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)fieldNode);
        Assert.assertEquals((Object)"Architecture", (Object)fieldNode.getTextContent());
        schemaNode = (Node)xpath.evaluate("//schema[@name='file']", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)schemaNode);
        fieldNode = (Node)xpath.evaluate("//file:filename[@type='string']", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)fieldNode);
        Assert.assertEquals((Object)"test_file.doc", (Object)fieldNode.getTextContent());
        fieldNode = (Node)xpath.evaluate("//file:content[@type='content']", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)fieldNode);
        fieldNode = (Node)xpath.evaluate("//file:content[@type='content']/encoding", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)fieldNode);
        Assert.assertEquals((Object)"UTF-8", (Object)fieldNode.getTextContent());
        fieldNode = (Node)xpath.evaluate("//file:content[@type='content']/mime-type", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)fieldNode);
        Assert.assertEquals((Object)"text/plain", (Object)fieldNode.getTextContent());
        fieldNode = (Node)xpath.evaluate("//file:content[@type='content']/filename", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)fieldNode);
        Assert.assertEquals((Object)"test_file.doc", (Object)fieldNode.getTextContent());
        fieldNode = (Node)xpath.evaluate("//file:content[@type='content']/data", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)fieldNode);
        Assert.assertTrue((!StringUtils.isEmpty((String)fieldNode.getTextContent()) ? 1 : 0) != 0);
        fieldNode = (Node)xpath.evaluate("//file:content[@type='content']/digest", document, XPathConstants.NODE);
        Assert.assertNotNull((Object)fieldNode);
        Assert.assertTrue((!StringUtils.isEmpty((String)fieldNode.getTextContent()) ? 1 : 0) != 0);
    }

    protected final org.w3c.dom.Document dom4jToW3c(Document dom4jdoc) throws TransformerException {
        DocumentSource source = new DocumentSource(dom4jdoc);
        DOMResult result = new DOMResult();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform((Source)source, result);
        return (org.w3c.dom.Document)result.getNode();
    }

    protected final class CoreNamespaceContext
    implements NamespaceContext {
        protected CoreNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if ("dc".equals(prefix)) {
                return "http://www.nuxeo.org/ecm/schemas/dublincore/";
            }
            if ("file".equals(prefix)) {
                return "http://www.nuxeo.org/ecm/schemas/file/";
            }
            return "";
        }

        @Override
        public String getPrefix(String namespace) {
            return null;
        }

        public Iterator getPrefixes(String namespace) {
            return null;
        }
    }
}

