/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.core.io.registry.MarshallerRegistry;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
public abstract class AbstractJsonWriterTest<WriterClass extends Writer<MarshalledType>, MarshalledType> {
    @Inject
    protected MarshallerRegistry registry;
    private Class<WriterClass> writerClass;
    private Class<?> marshalledClass;
    private Type marshalledGenericType;

    public AbstractJsonWriterTest(Class<WriterClass> writerClass, Class<?> marshalledClass) {
        this(writerClass, marshalledClass, marshalledClass);
    }

    public AbstractJsonWriterTest(Class<WriterClass> writerClass, Class<?> marshalledClass, Type marshalledGenericType) {
        this.writerClass = writerClass;
        this.marshalledClass = marshalledClass;
        this.marshalledGenericType = marshalledGenericType;
    }

    public WriterClass getInstance() {
        return (WriterClass)((Writer)this.registry.getInstance(RenderingContext.CtxBuilder.get(), this.writerClass));
    }

    public WriterClass getInstance(RenderingContext ctx) {
        return (WriterClass)((Writer)this.registry.getInstance(ctx, this.writerClass));
    }

    public String asJson(MarshalledType object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.getInstance().write(object, this.marshalledClass, this.marshalledGenericType, MediaType.APPLICATION_JSON_TYPE, (OutputStream)baos);
        return baos.toString();
    }

    public String asJson(MarshalledType object, RenderingContext ctx) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.getInstance(ctx).write(object, this.marshalledClass, this.marshalledGenericType, MediaType.APPLICATION_JSON_TYPE, (OutputStream)baos);
        return baos.toString();
    }

    public JsonAssert jsonAssert(MarshalledType object) throws IOException {
        return JsonAssert.on(this.asJson(object));
    }

    public JsonAssert jsonAssert(MarshalledType object, RenderingContext ctx) throws IOException {
        return JsonAssert.on(this.asJson(object, ctx));
    }

    @Deploy(value={"org.nuxeo.ecm.core.io"})
    public static abstract class External<WriterClass extends Writer<MarshalledType>, MarshalledType>
    extends AbstractJsonWriterTest<WriterClass, MarshalledType> {
        public External(Class<WriterClass> writerClass, Class<?> marshalledClass, Type marshalledGenericType) {
            super(writerClass, marshalledClass, marshalledGenericType);
        }

        public External(Class<WriterClass> writerClass, Class<?> marshalledClass) {
            super(writerClass, marshalledClass);
        }
    }

    @Deploy(value={"org.nuxeo.ecm.core.io:OSGI-INF/MarshallerRegistry.xml", "org.nuxeo.ecm.core.io:OSGI-INF/marshallers-contrib.xml"})
    public static abstract class Local<WriterClass extends Writer<MarshalledType>, MarshalledType>
    extends AbstractJsonWriterTest<WriterClass, MarshalledType> {
        public Local(Class<WriterClass> writerClass, Class<?> marshalledClass, Type marshalledGenericType) {
            super(writerClass, marshalledClass, marshalledGenericType);
        }

        public Local(Class<WriterClass> writerClass, Class<?> marshalledClass) {
            super(writerClass, marshalledClass);
        }
    }
}

