/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonNode;
import org.junit.Assert;
import org.nuxeo.ecm.core.io.marshallers.json.JsonFactoryProvider;

public class JsonAssert {
    private JsonNode jsonNode;

    private JsonAssert(String json) throws IOException {
        this.jsonNode = JsonFactoryProvider.get().createJsonParser(json).readValueAsTree();
    }

    private JsonAssert(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
    }

    public static JsonAssert on(String json) throws IOException {
        return new JsonAssert(json);
    }

    public JsonNode getNode() {
        return this.jsonNode;
    }

    public String toString() {
        return this.jsonNode.toString();
    }

    public JsonAssert get(int index) throws IOException {
        return this.get("[" + index + "]");
    }

    public JsonAssert get(String jsonPath) throws IOException {
        String SEPARATOR = "<SEP>";
        String pattern = "[\\[\\]\\.]";
        Iterator<String> tokens = Arrays.asList(jsonPath.replaceAll("(" + pattern + ")", SEPARATOR + "$1" + SEPARATOR).split(SEPARATOR)).iterator();
        JsonNode jn = this.jsonNode;
        String read = "";
        block10: while (tokens.hasNext()) {
            String token = tokens.next();
            if (StringUtils.isBlank((String)token)) continue;
            switch (token) {
                case ".": {
                    read = read + token;
                    continue block10;
                }
                case "[": {
                    read = read + token;
                    if (!tokens.hasNext()) {
                        throw new IOException("Invalid json parameter value : [ must be followed by a index and by ] :" + read);
                    }
                    Integer index = null;
                    try {
                        index = Integer.valueOf(tokens.next());
                        read = read + index;
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Invalid json parameter value : [ must be followed by a index and by ] :" + read);
                    }
                    if (index < 0) {
                        throw new IOException("Invalid json parameter value : [ must be followed by a index and by ] :" + read);
                    }
                    if (!tokens.hasNext() || !"]".equals(tokens.next())) {
                        throw new IOException("Invalid json parameter value : [ must be followed by a index and by ] :" + read);
                    }
                    read = read + "]";
                    if (!jn.isArray()) {
                        throw new IOException(read + " is not a array");
                    }
                    if (!jn.has(index.intValue())) {
                        return null;
                    }
                    jn = jn.get(index.intValue());
                    continue block10;
                }
            }
            if (!jn.isObject()) {
                throw new IOException(read + " is not an object");
            }
            if (!jn.has(token)) {
                return null;
            }
            read = read + token;
            jn = jn.get(token);
        }
        return new JsonAssert(jn);
    }

    public JsonAssert has(int index) throws IOException {
        JsonAssert jsonAssert = this.get(index);
        Assert.assertNotNull((String)("no field " + index), (Object)jsonAssert);
        return jsonAssert;
    }

    public JsonAssert hasNot(int index) throws IOException {
        Assert.assertNull((String)"field is present", (Object)this.get(index));
        return this;
    }

    public JsonAssert has(String path) throws IOException {
        JsonAssert jsonAssert = this.get(path);
        Assert.assertNotNull((String)("no field " + path), (Object)jsonAssert);
        return jsonAssert;
    }

    public JsonAssert hasNot(String path) throws IOException {
        Assert.assertNull((String)"field is present", (Object)this.get(path));
        return this;
    }

    public JsonAssert isNull() {
        Assert.assertTrue((String)"value is not null", (boolean)this.jsonNode.isNull());
        return this;
    }

    public JsonAssert isEmptyStringOrNull() {
        if (!this.jsonNode.isNull()) {
            this.isEquals("");
        }
        return this;
    }

    public JsonAssert notNull() {
        Assert.assertFalse((String)"value is null", (boolean)this.jsonNode.isNull());
        return this;
    }

    public JsonAssert isText() {
        this.notNull();
        Assert.assertTrue((String)"not a text value", (boolean)this.jsonNode.isTextual());
        return this;
    }

    public JsonAssert isEquals(String expected) {
        this.isText();
        String value = this.jsonNode.getTextValue();
        Assert.assertEquals((String)this.equalsMsg(expected, value), (Object)expected, (Object)value);
        return this;
    }

    public JsonAssert notEquals(String expected) {
        this.isText();
        Assert.assertNotEquals((String)this.notEqualsMsg(expected), (Object)expected, (Object)this.jsonNode.getTextValue());
        return this;
    }

    public JsonAssert isBool() {
        this.notNull();
        Assert.assertTrue((String)"not a boolean value", (boolean)this.jsonNode.isBoolean());
        return this;
    }

    public JsonAssert isTrue() {
        this.isBool();
        Assert.assertTrue((String)"is not true", (boolean)this.jsonNode.getBooleanValue());
        return this;
    }

    public JsonAssert isFalse() {
        this.isBool();
        Assert.assertFalse((String)"is not false", (boolean)this.jsonNode.getBooleanValue());
        return this;
    }

    public JsonAssert isEquals(boolean expected) {
        this.isBool();
        boolean value = this.jsonNode.getBooleanValue();
        Assert.assertEquals((String)this.equalsMsg(expected, value), (Object)expected, (Object)value);
        return this;
    }

    public JsonAssert isNotEquals(boolean expected) {
        this.isBool();
        boolean value = this.jsonNode.getBooleanValue();
        Assert.assertNotEquals((String)this.notEqualsMsg(expected), (Object)expected, (Object)value);
        return this;
    }

    public JsonAssert isInt() {
        this.notNull();
        Assert.assertTrue((String)"not an int", (boolean)this.jsonNode.isIntegralNumber());
        return this;
    }

    public JsonAssert isEquals(int expected) {
        this.isInt();
        int value = this.jsonNode.getIntValue();
        Assert.assertEquals((String)this.equalsMsg(expected, value), (long)expected, (long)value);
        return this;
    }

    public JsonAssert notEquals(int expected) {
        this.isInt();
        Assert.assertNotEquals((String)this.notEqualsMsg(expected), (long)expected, (long)this.jsonNode.getLongValue());
        return this;
    }

    public JsonAssert isEquals(long expected) {
        this.isInt();
        long value = this.jsonNode.getLongValue();
        Assert.assertEquals((String)this.equalsMsg(expected, value), (long)expected, (long)value);
        return this;
    }

    public JsonAssert notEquals(long expected) {
        this.isInt();
        Assert.assertNotEquals((String)this.notEqualsMsg(expected), (long)expected, (long)this.jsonNode.getLongValue());
        return this;
    }

    public JsonAssert isDouble() {
        this.notNull();
        Assert.assertTrue((String)"not a double", (boolean)this.jsonNode.isFloatingPointNumber());
        return this;
    }

    public JsonAssert isEquals(double expected, double delta) {
        this.isDouble();
        double value = this.jsonNode.getDoubleValue();
        Assert.assertEquals((String)this.equalsMsg(expected, value + " +- " + delta), (double)expected, (double)value, (double)delta);
        return this;
    }

    public JsonAssert notEquals(double expected, double delta) {
        this.isDouble();
        Assert.assertNotEquals((String)this.notEqualsMsg(expected + " +- " + delta), (Object)this.jsonNode.getDoubleValue(), (Object)delta);
        return this;
    }

    public JsonAssert isEquals(float expected, float delta) {
        this.isDouble();
        double value = this.jsonNode.getDoubleValue();
        Assert.assertEquals((String)this.equalsMsg(Float.valueOf(expected), value + " +- " + delta), (double)expected, (double)value, (double)delta);
        return this;
    }

    public JsonAssert notEquals(float expected, float delta) {
        this.isDouble();
        Assert.assertNotEquals((String)this.notEqualsMsg(expected + " +- " + delta), (Object)this.jsonNode.getDoubleValue(), (Object)Float.valueOf(delta));
        return this;
    }

    public JsonAssert isEquals(BigDecimal expected) {
        this.isDouble();
        BigDecimal value = this.jsonNode.getDecimalValue();
        Assert.assertEquals((String)this.equalsMsg(expected, value), (Object)expected, (Object)value);
        return this;
    }

    public JsonAssert notEquals(BigDecimal expected) {
        this.isDouble();
        Assert.assertNotEquals((Object)this.notEqualsMsg(expected), (Object)this.jsonNode.getDecimalValue());
        return this;
    }

    public JsonAssert isBinary() {
        this.notNull();
        Assert.assertTrue((String)"not a binary", (boolean)this.jsonNode.isBinary());
        return this;
    }

    public JsonAssert isEquals(byte[] expected) throws IOException {
        this.isBinary();
        byte[] value = this.jsonNode.getBinaryValue();
        Assert.assertEquals((String)this.equalsMsg(expected, value), (Object)expected, (Object)value);
        return this;
    }

    public JsonAssert notEquals(byte[] expected) throws IOException {
        this.isBinary();
        Assert.assertNotEquals((Object)this.notEqualsMsg(expected), (Object)this.jsonNode.getBinaryValue());
        return this;
    }

    public JsonAssert isObject() {
        this.notNull();
        Assert.assertTrue((String)"is not an object", (boolean)this.jsonNode.isObject());
        return this;
    }

    public JsonAssert notObject() {
        this.notNull();
        Assert.assertTrue((String)"is an object", (boolean)this.jsonNode.isObject());
        return this;
    }

    public JsonAssert properties(int count) {
        this.isObject();
        int found = 0;
        Iterator it = this.jsonNode.getElements();
        while (it.hasNext()) {
            ++found;
            it.next();
        }
        Assert.assertEquals((String)("Expected " + count + " children but found " + found), (long)count, (long)found);
        return this;
    }

    public JsonAssert isArray() {
        this.notNull();
        Assert.assertTrue((String)"is not an array", (boolean)this.jsonNode.isArray());
        return this;
    }

    public JsonAssert notArray() {
        this.notNull();
        Assert.assertTrue((String)"is an array", (boolean)this.jsonNode.isArray());
        return this;
    }

    public JsonAssert length(int length) {
        this.isArray();
        if (length == 0) {
            Assert.assertFalse((String)("has more than 0 element : " + this.jsonNode.toString()), (boolean)this.jsonNode.has(0));
            return this;
        }
        Assert.assertTrue((String)("has less than " + length + " elements"), (boolean)this.jsonNode.has(length - 1));
        Assert.assertFalse((String)("has more than " + length + " elements"), (boolean)this.jsonNode.has(length));
        return this;
    }

    public JsonAssert contains(String ... expecteds) {
        Integer n;
        this.length(expecteds.length);
        JsonNode jn = null;
        Iterator it = this.jsonNode.getElements();
        HashMap<String, Integer> expectedMap = new HashMap<String, Integer>();
        for (String value : expecteds) {
            Integer count = (Integer)expectedMap.get(value);
            if (count == null) {
                count = 0;
            }
            n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            expectedMap.put(value, count);
        }
        HashMap<String, Integer> foundMap = new HashMap<String, Integer>();
        ArrayList<String> founds = new ArrayList<String>();
        while (it.hasNext()) {
            jn = (JsonNode)it.next();
            String value = jn.isNull() ? null : jn.getValueAsText();
            founds.add(value);
            Integer count = (Integer)foundMap.get(value);
            if (count == null) {
                count = 0;
            }
            Integer n3 = count;
            n = count = Integer.valueOf(count + 1);
            foundMap.put(value, count);
        }
        Assert.assertEquals((String)("some value were not found or not expected: found=" + founds), expectedMap, foundMap);
        return this;
    }

    public JsonAssert childrenContains(String path, String ... values) throws IOException {
        Integer n;
        List<String> founds = this.getAll(path, this.jsonNode);
        Assert.assertEquals((String)("found more or less element thant expected : found=" + founds), (long)values.length, (long)founds.size());
        HashMap<String, Integer> expectedMap = new HashMap<String, Integer>();
        for (String value : values) {
            Integer count = (Integer)expectedMap.get(value);
            if (count == null) {
                count = 0;
            }
            n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            expectedMap.put(value, count);
        }
        HashMap<String, Integer> foundMap = new HashMap<String, Integer>();
        for (String value : founds) {
            Integer count = (Integer)foundMap.get(value);
            if (count == null) {
                count = 0;
            }
            Integer n3 = count;
            n = count = Integer.valueOf(count + 1);
            foundMap.put(value, count);
        }
        Assert.assertEquals((String)("some value were not found or not expected: found=" + founds), expectedMap, foundMap);
        return this;
    }

    private List<String> getAll(String path, JsonNode node) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        if (!node.isArray()) {
            int index = path.indexOf(46);
            if (index < 0) {
                JsonNode el = node.get(path);
                if (el.isNull()) {
                    result.add(null);
                } else {
                    result.add(el.getValueAsText());
                }
            } else {
                String token = path.substring(0, index);
                JsonNode el = node.get(token);
                String rest = path.substring(index + 1);
                result.addAll(this.getAll(rest, el));
            }
        } else {
            Iterator it = node.getElements();
            while (it.hasNext()) {
                result.addAll(this.getAll(path, (JsonNode)it.next()));
            }
        }
        return result;
    }

    private String equalsMsg(Object expected, Object value) {
        return "expected : " + expected + " but was " + value;
    }

    private String notEqualsMsg(Object expected) {
        return "is equals to expected : " + expected;
    }

    @Deprecated
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

