/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.document;

import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.UserEntry;
import org.nuxeo.ecm.core.api.security.impl.UserEntryImpl;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriterTest;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.core.io.marshallers.json.document.ACPJsonWriter;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@LocalDeploy(value={"org.nuxeo.ecm.core.io:OSGI-INF/doc-type-contrib.xml"})
public class ACPJsonWriterTest
extends AbstractJsonWriterTest.Local<ACPJsonWriter, ACP> {
    private DocumentModel document;
    @Inject
    private CoreSession session;

    public ACPJsonWriterTest() {
        super(ACPJsonWriter.class, ACP.class);
    }

    @Before
    public void setup() {
        this.document = this.session.createDocumentModel("/", "myDoc", "Document");
        this.document = this.session.createDocument(this.document);
        UserEntryImpl entry = new UserEntryImpl("SpongeBob");
        entry.addPrivilege("DancingWithPatrickStar");
        this.document.getACP().setRules("SpongeBobRules", new UserEntry[]{entry});
    }

    @Test
    public void test() throws Exception {
        JsonAssert json = this.jsonAssert(this.document.getACP());
        json.isObject();
        json.properties(2);
        json.has("entity-type").isEquals("acls");
        json = json.has("acl").isArray();
        json.length(2);
        json.has(1).has("name").isEquals("inherited");
        json = json.has(0);
        json.has("name").isEquals("SpongeBobRules");
        json = json.has("ace").length(1);
        json = json.has(0).isObject();
        json.has("username").isEquals("SpongeBob");
        json.has("permission").isEquals("DancingWithPatrickStar");
        json.has("granted").isTrue();
    }
}

