/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.document;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriterTest;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.core.io.marshallers.json.JsonFactoryProvider;
import org.nuxeo.ecm.core.io.marshallers.json.document.DocumentModelJsonReader;
import org.nuxeo.ecm.core.io.marshallers.json.document.DocumentModelJsonWriter;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@LocalDeploy(value={"org.nuxeo.ecm.core.test.tests:OSGI-INF/defaultvalue-docTypes.xml"})
public class DocumentModelJsonReaderTest
extends AbstractJsonWriterTest.Local<DocumentModelJsonWriter, DocumentModel> {
    private DocumentModel document;
    @Inject
    private CoreSession session;

    public DocumentModelJsonReaderTest() {
        super(DocumentModelJsonWriter.class, DocumentModel.class);
    }

    @Before
    public void setup() {
        this.document = this.session.createDocumentModel("/", "myNote", "Note");
        this.document.setPropertyValue("dc:title", (Serializable)((Object)"My Note"));
        this.document = this.session.createDocument(this.document);
    }

    @Test
    public void testDefault() throws Exception {
        RenderingContext renderingContext = RenderingContext.CtxBuilder.get();
        renderingContext.setExistingSession(this.session);
        DocumentModelJsonReader reader = (DocumentModelJsonReader)this.registry.getInstance(renderingContext, DocumentModelJsonReader.class);
        JsonAssert json = this.jsonAssert(this.document);
        DocumentModel doc = (DocumentModel)reader.read(json.getNode());
        Assert.assertTrue((boolean)(doc instanceof DocumentModelImpl));
        Assert.assertEquals((Object)"myNote", (Object)doc.getName());
        Assert.assertEquals((Object)"My Note", (Object)doc.getPropertyValue("dc:title"));
    }

    @Test
    public void testReadSchemaWithoutPrefix() throws IOException {
        String noteJson = "{ \"entity-type\": \"document\",\n  \"type\": \"Note\",\n  \"name\": \"aNote\",\n  \"properties\":\n   { \"dc:title\": \"A note\",\n     \"note:note\": \"note content\" } }";
        DocumentModelJsonReader reader = (DocumentModelJsonReader)this.registry.getInstance(RenderingContext.CtxBuilder.get(), DocumentModelJsonReader.class);
        JsonParser jp = JsonFactoryProvider.get().createJsonParser(noteJson);
        JsonNode jn = jp.readValueAsTree();
        DocumentModel noteDocument = (DocumentModel)reader.read(jn);
        Assert.assertNotNull((Object)noteDocument);
        Assert.assertTrue((boolean)(noteDocument instanceof SimpleDocumentModel));
        Assert.assertEquals((Object)"note content", (Object)noteDocument.getPropertyValue("note:note"));
    }

    @Test
    public void testScalarCreatedWithDefaultValue() throws Exception {
        String noteJson = "{ \"entity-type\": \"document\", \"type\": \"DocDefaultValue\", \"name\": \"aDoc\" }";
        DocumentModelJsonReader reader = (DocumentModelJsonReader)this.registry.getInstance(RenderingContext.CtxBuilder.get(), DocumentModelJsonReader.class);
        JsonParser jp = JsonFactoryProvider.get().createJsonParser(noteJson);
        JsonNode jn = jp.readValueAsTree();
        DocumentModel noteDocument = (DocumentModel)reader.read(jn);
        String[] schemas = noteDocument.getSchemas();
        Assert.assertEquals((long)1L, (long)schemas.length);
        Assert.assertEquals((Object)"defaultvalue", (Object)schemas[0]);
        Map values = noteDocument.getDataModel("defaultvalue").getMap();
        Assert.assertNull(null, values.get("dv:simpleWithoutDefault"));
        Assert.assertEquals((Object)"value", values.get("dv:simpleWithDefault"));
    }

    @Test
    public void testScalarSetOnNullDontSetDefaultValueAgain() throws Exception {
        String noteJson = "{ \"entity-type\": \"document\", \"type\": \"DocDefaultValue\", \"name\": \"aDoc\", \"properties\": {\"dv:simpleWithDefault\":null} }";
        DocumentModelJsonReader reader = (DocumentModelJsonReader)this.registry.getInstance(RenderingContext.CtxBuilder.get(), DocumentModelJsonReader.class);
        JsonParser jp = JsonFactoryProvider.get().createJsonParser(noteJson);
        JsonNode jn = jp.readValueAsTree();
        DocumentModel noteDocument = (DocumentModel)reader.read(jn);
        Map values = noteDocument.getDataModel("defaultvalue").getMap();
        Assert.assertNull(values.get("dv:simpleWithDefault"));
    }

    @Test
    public void testMultiCreatedWithDefaultValue() throws Exception {
        String noteJson = "{ \"entity-type\": \"document\", \"type\": \"DocDefaultValue\", \"name\": \"aDoc\" }";
        DocumentModelJsonReader reader = (DocumentModelJsonReader)this.registry.getInstance(RenderingContext.CtxBuilder.get(), DocumentModelJsonReader.class);
        JsonParser jp = JsonFactoryProvider.get().createJsonParser(noteJson);
        JsonNode jn = jp.readValueAsTree();
        DocumentModel noteDocument = (DocumentModel)reader.read(jn);
        String[] schemas = noteDocument.getSchemas();
        Assert.assertEquals((long)1L, (long)schemas.length);
        Assert.assertEquals((Object)"defaultvalue", (Object)schemas[0]);
        Map values = noteDocument.getDataModel("defaultvalue").getMap();
        Assert.assertNull(null, values.get("dv:multiWithoutDefault"));
        Assert.assertArrayEquals((Object[])new String[]{"value1", "value2"}, (Object[])((String[])values.get("dv:multiWithDefault")));
    }

    @Test
    public void testMultiSetOnNullDontSetDefaultValueAgain() throws Exception {
        String noteJson = "{ \"entity-type\": \"document\", \"type\": \"DocDefaultValue\", \"name\": \"aDoc\", \"properties\": {\"dv:multiWithDefault\":null} }";
        DocumentModelJsonReader reader = (DocumentModelJsonReader)this.registry.getInstance(RenderingContext.CtxBuilder.get(), DocumentModelJsonReader.class);
        JsonParser jp = JsonFactoryProvider.get().createJsonParser(noteJson);
        JsonNode jn = jp.readValueAsTree();
        DocumentModel noteDocument = (DocumentModel)reader.read(jn);
        Map values = noteDocument.getDataModel("defaultvalue").getMap();
        Assert.assertNull(values.get("dv:multiWithDefault"));
    }
}

