/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.document;

import java.io.Serializable;
import java.util.Date;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriterTest;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.core.io.marshallers.json.document.DocumentModelJsonWriter;
import org.nuxeo.ecm.core.io.registry.context.DepthValues;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@LocalDeploy(value={"org.nuxeo.ecm.core.io:OSGI-INF/doc-type-contrib.xml"})
public class DocumentModelJsonWriterTest
extends AbstractJsonWriterTest.Local<DocumentModelJsonWriter, DocumentModel> {
    private DocumentModel document;
    @Inject
    private CoreSession session;
    @Inject
    private SchemaManager schemaManager;

    public DocumentModelJsonWriterTest() {
        super(DocumentModelJsonWriter.class, DocumentModel.class);
    }

    @Before
    public void setup() {
        this.document = this.session.createDocumentModel("/", "myDoc", "RefDoc");
        this.document = this.session.createDocument(this.document);
    }

    @Test
    public void testDefault() throws Exception {
        JsonAssert json = this.jsonAssert(this.document);
        json.isObject();
        json.properties(11);
        json.has("entity-type").isEquals("document");
        json.has("repository").isEquals("test");
        json.has("uid").isEquals(this.document.getId());
        json.has("path").isEquals("/myDoc");
        json.has("type").isEquals("RefDoc");
        json.has("state").isEquals("undefined");
        json.has("parentRef").isEquals(this.document.getParentRef().toString());
        json.has("isCheckedOut").isTrue();
        json.has("changeToken").isNull();
        json.has("title").isEquals("myDoc");
        json.has("facets").contains("Folderish");
    }

    @Test
    public void testWithVersion() throws Exception {
        JsonAssert json = this.jsonAssert(this.document, RenderingContext.CtxBuilder.fetchInDoc((String[])new String[]{"versionLabel"}).get());
        json.isObject();
        json.properties(12);
        json.has("versionLabel").isEquals("");
    }

    @Test
    public void testWithLastModified() throws Exception {
        this.document.setPropertyValue("dc:modified", (Serializable)new Date());
        JsonAssert json = this.jsonAssert(this.document);
        json.isObject();
        json.properties(12);
        json.has("lastModified").isText();
    }

    @Test
    public void testTitleIsDcTitle() throws Exception {
        String title = "My document";
        this.document.setPropertyValue("dc:title", (Serializable)((Object)title));
        JsonAssert json = this.jsonAssert(this.document, RenderingContext.CtxBuilder.properties((String[])new String[]{"*"}).get());
        json.has("title").isEquals(title);
    }

    @Test
    public void testWithAllProperties() throws Exception {
        JsonAssert json = this.jsonAssert(this.document, RenderingContext.CtxBuilder.properties((String[])new String[]{"*"}).get());
        json = json.has("properties");
        json.isObject();
        int nbProperties = 0;
        for (String schemaName : this.document.getSchemas()) {
            Schema schema = this.schemaManager.getSchema(schemaName);
            for (Field field : schema.getFields()) {
                ++nbProperties;
                String prefixedName = field.getName().getPrefixedName();
                if (!prefixedName.contains(":")) {
                    prefixedName = schemaName + ":" + prefixedName;
                }
                json.has(prefixedName);
            }
        }
        json.properties(nbProperties);
    }

    @Test
    public void testStringPropertyValue() throws Exception {
        String value = "toto";
        String propName = "dr:propString";
        this.document.setPropertyValue(propName, (Serializable)((Object)value));
        JsonAssert json = this.jsonAssert(this.document, RenderingContext.CtxBuilder.properties((String[])new String[]{"documentResolver"}).get());
        json.has("properties." + propName).isEquals(value);
    }

    @Test
    public void testIntPropertyValue() throws Exception {
        int value = 123;
        String propName = "dr:propInt";
        this.document.setPropertyValue(propName, (Serializable)Integer.valueOf(value));
        JsonAssert json = this.jsonAssert(this.document, RenderingContext.CtxBuilder.properties((String[])new String[]{"documentResolver"}).get());
        json.has("properties." + propName).isEquals(value);
    }

    @Test
    public void testDoublePropertyValue() throws Exception {
        double value = 123.123;
        String propName = "dr:propDouble";
        this.document.setPropertyValue(propName, (Serializable)Double.valueOf(value));
        JsonAssert json = this.jsonAssert(this.document, RenderingContext.CtxBuilder.properties((String[])new String[]{"documentResolver"}).get());
        json.has("properties." + propName).isEquals(value, 0.0);
    }

    @Test
    public void testBooleanPropertyValue() throws Exception {
        String propName = "dr:propBoolean";
        this.document.setPropertyValue(propName, (Serializable)Boolean.valueOf(true));
        JsonAssert json = this.jsonAssert(this.document, RenderingContext.CtxBuilder.properties((String[])new String[]{"documentResolver"}).get());
        json.has("properties." + propName).isTrue();
    }

    @Test
    public void testDatePropertyValue() throws Exception {
        Date value = new Date();
        String propName = "dr:propDate";
        this.document.setPropertyValue(propName, (Serializable)value);
        JsonAssert json = this.jsonAssert(this.document, RenderingContext.CtxBuilder.properties((String[])new String[]{"documentResolver"}).get());
        json.has("properties." + propName).isEquals(DateParser.formatW3CDateTime((Date)value));
    }

    @Test
    public void testListPropertyValue() throws Exception {
        String pathRef1 = "test:/";
        String pathRef2 = "test:/myDoc";
        Property list = this.document.getProperty("dr:docPathRefList");
        list.addValue((Object)pathRef1);
        list.addValue((Object)pathRef2);
        JsonAssert json = this.jsonAssert(this.document, RenderingContext.CtxBuilder.properties((String[])new String[]{"documentResolver"}).get());
        json.has("properties.dr:docPathRefList").contains(pathRef1, pathRef2);
    }

    @Test
    public void testComplexPropertyValue() throws Exception {
        String pathRef = "test:/";
        String idRef = "test:" + this.document.getId();
        Property list = this.document.getProperty("dr:docRefType");
        list.setValue("docRefTypePath", (Object)pathRef);
        list.setValue("docRefTypeId", (Object)idRef);
        JsonAssert json = this.jsonAssert(this.document, RenderingContext.CtxBuilder.properties((String[])new String[]{"documentResolver"}).get());
        json = json.has("properties.dr:docRefType").isObject();
        json.has("docRefTypePath").isEquals(pathRef);
        json.has("docRefTypeId").isEquals(idRef);
    }

    @Test
    public void testNoFetching() throws Exception {
        String pathRef = "test:/";
        String xpath = "dr:docPathRef";
        this.document.setPropertyValue(xpath, (Serializable)((Object)pathRef));
        JsonAssert json = this.jsonAssert(this.document, RenderingContext.CtxBuilder.properties((String[])new String[]{"*"}).get());
        json.has("properties." + xpath).isEquals(pathRef);
    }

    @Test
    public void testSimpleFetching() throws Exception {
        String pathRef = "test:/";
        String xpath = "dr:docPathRef";
        this.document.setPropertyValue(xpath, (Serializable)((Object)pathRef));
        JsonAssert json = this.jsonAssert(this.document, RenderingContext.CtxBuilder.properties((String[])new String[]{"*"}).fetchInDoc(new String[]{xpath}).get());
        json = json.has("properties." + xpath).isObject();
        json.has("entity-type").isEquals("document");
        json.has("path").isEquals("/");
    }

    @Test
    public void testArrayPropertiesFetching() throws Exception {
        String pathRef = "test:/";
        String xpath = "dr:docPathRefSimpleList";
        this.document.setPropertyValue(xpath, (Serializable)new String[]{pathRef, pathRef, pathRef});
        JsonAssert json = this.jsonAssert(this.document, RenderingContext.CtxBuilder.properties((String[])new String[]{"*"}).fetchInDoc(new String[]{xpath}).get());
        json = json.has("properties." + xpath).isArray();
        json.length(3);
        json.childrenContains("entity-type", "document", "document", "document");
        json.childrenContains("path", "/", "/", "/");
    }

    @Test
    public void testInvalidValueFetching() throws Exception {
        String pathRef = "test:/toto/is/doing/something";
        String xpath = "dr:docPathRefSimpleList";
        this.document.setPropertyValue(xpath, (Serializable)new String[]{pathRef, pathRef});
        JsonAssert json = this.jsonAssert(this.document, RenderingContext.CtxBuilder.properties((String[])new String[]{"*"}).fetchInDoc(new String[]{xpath}).get());
        json = json.has("properties." + xpath).isArray();
        json.length(2);
        json.contains(pathRef, pathRef);
    }

    @Test
    public void testFullFetching() throws Exception {
        String pathRef = "test:/";
        this.document.setPropertyValue("dr:docPathRef", (Serializable)((Object)pathRef));
        this.document.getProperty("dr:docRefType").setValue("docRefTypePath", (Object)pathRef);
        this.document.getProperty("dr:docPathRefList").addValue((Object)pathRef);
        this.document.getProperty("dr:docPathRefSimpleList").setValue((Object)new String[]{pathRef, pathRef});
        JsonAssert json = this.jsonAssert(this.document, RenderingContext.CtxBuilder.properties((String[])new String[]{"*"}).fetchInDoc(new String[]{"properties"}).get());
        JsonAssert child = json.has("properties.dr:docPathRef").isObject();
        child.has("entity-type").isEquals("document");
        child.has("path").isEquals("/");
        child = json.has("properties.dr:docRefType.docRefTypePath").isObject();
        child.has("entity-type").isEquals("document");
        child.has("path").isEquals("/");
        child = json.has("properties.dr:docPathRefList[0]").isObject();
        child.has("entity-type").isEquals("document");
        child.has("path").isEquals("/");
        child = json.has("properties.dr:docPathRefSimpleList").isArray();
        child.length(2);
        child.childrenContains("entity-type", "document", "document");
        child.childrenContains("path", "/", "/");
    }

    @Test
    public void testDepthControl() throws Exception {
        DocumentModel root = this.session.createDocumentModel("/", "root", "RefDoc");
        root = this.session.createDocument(root);
        DocumentModel child = this.session.createDocumentModel("/root", "child", "RefDoc");
        child = this.session.createDocument(child);
        DocumentModel max = this.session.createDocumentModel("/root/child", "max", "RefDoc");
        max = this.session.createDocument(max);
        DocumentModel over = this.session.createDocumentModel("/root/child/max", "over", "RefDoc");
        over = this.session.createDocument(over);
        RenderingContext ctxDefault = RenderingContext.CtxBuilder.properties((String[])new String[]{"*"}).enrichDoc(new String[]{"children"}).get();
        JsonAssert jsonDefault = this.jsonAssert(root, ctxDefault);
        jsonDefault.has("properties");
        jsonDefault.has("contextParameters");
        jsonDefault = jsonDefault.has("contextParameters.children.entries[0]");
        jsonDefault.hasNot("properties");
        jsonDefault.hasNot("contextParameters");
        RenderingContext ctxRoot = RenderingContext.CtxBuilder.properties((String[])new String[]{"*"}).enrichDoc(new String[]{"children"}).depth(DepthValues.root).get();
        JsonAssert jsonRoot = this.jsonAssert(root, ctxRoot);
        jsonRoot.has("properties");
        jsonRoot.has("contextParameters");
        jsonRoot = jsonRoot.has("contextParameters.children.entries[0]");
        jsonRoot.hasNot("properties");
        jsonRoot.hasNot("contextParameters");
        RenderingContext ctxChildren = RenderingContext.CtxBuilder.properties((String[])new String[]{"*"}).enrichDoc(new String[]{"children"}).depth(DepthValues.children).get();
        JsonAssert jsonChildren = this.jsonAssert(root, ctxChildren);
        jsonChildren.has("properties");
        jsonChildren.has("contextParameters");
        jsonChildren = jsonChildren.has("contextParameters.children.entries[0]");
        jsonChildren.has("properties");
        jsonChildren.has("contextParameters");
        jsonChildren = jsonChildren.has("contextParameters.children.entries[0]");
        jsonChildren.hasNot("properties");
        jsonChildren.hasNot("contextParameters");
        RenderingContext ctxMax = RenderingContext.CtxBuilder.properties((String[])new String[]{"*"}).enrichDoc(new String[]{"children"}).depth(DepthValues.max).get();
        JsonAssert jsonMax = this.jsonAssert(root, ctxMax);
        jsonMax.has("properties");
        jsonMax.has("contextParameters");
        jsonMax = jsonMax.has("contextParameters.children.entries[0]");
        jsonMax.has("properties");
        jsonMax.has("contextParameters");
        jsonMax = jsonMax.has("contextParameters.children.entries[0]");
        jsonMax.has("properties");
        jsonMax.has("contextParameters");
        jsonMax = jsonMax.has("contextParameters.children.entries[0]");
        jsonMax.hasNot("properties");
        jsonMax.hasNot("contextParameters");
    }
}

