/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.document;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.junit.Test;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriterTest;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.core.io.marshallers.json.document.DocumentModelListJsonWriter;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@LocalDeploy(value={"org.nuxeo.ecm.core.io:OSGI-INF/doc-type-contrib.xml"})
public class DocumentModelListJsonWriterTest
extends AbstractJsonWriterTest.Local<DocumentModelListJsonWriter, List<DocumentModel>> {
    @Inject
    private CoreSession session;

    public DocumentModelListJsonWriterTest() {
        super(DocumentModelListJsonWriter.class, List.class, TypeUtils.parameterize(List.class, (Type[])new Type[]{DocumentModel.class}));
    }

    public List<DocumentModel> getElements() {
        DocumentModel document1 = this.session.createDocumentModel("/", "myDoc1", "RefDoc");
        document1 = this.session.createDocument(document1);
        DocumentModel document2 = this.session.createDocumentModel("/", "myDoc2", "RefDoc");
        document2 = this.session.createDocument(document2);
        DocumentModel document3 = this.session.createDocumentModel("/", "myDoc3", "RefDoc");
        document3 = this.session.createDocument(document3);
        return Arrays.asList(document1, document2, document3);
    }

    @Test
    public void test() throws Exception {
        List<DocumentModel> elements = this.getElements();
        JsonAssert json = this.jsonAssert(elements);
        json.isObject();
        json.properties(2);
        json.has("entity-type").isEquals("documents");
        json = json.has("entries").length(elements.size());
        json.childrenContains("entity-type", "document", "document", "document");
        json.childrenContains("title", "myDoc1", "myDoc2", "myDoc3");
    }
}

