/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.enrichers;

import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriterTest;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.core.io.marshallers.json.document.DocumentModelJsonWriter;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@LocalDeploy(value={"org.nuxeo.ecm.core.io:OSGI-INF/doc-type-contrib.xml"})
public class BreadcrumbJsonEnricherTest
extends AbstractJsonWriterTest.Local<DocumentModelJsonWriter, DocumentModel> {
    private DocumentModel document;
    @Inject
    private CoreSession session;

    public BreadcrumbJsonEnricherTest() {
        super(DocumentModelJsonWriter.class, DocumentModel.class);
    }

    @Before
    public void setup() {
        this.document = this.session.createDocumentModel("/", "level1", "RefDoc");
        this.document = this.session.createDocument(this.document);
        this.document = this.session.createDocumentModel("/level1", "level2", "RefDoc");
        this.document = this.session.createDocument(this.document);
        this.document = this.session.createDocumentModel("/level1/level2", "level3", "RefDoc");
        this.document = this.session.createDocument(this.document);
    }

    @Test
    public void test() throws Exception {
        JsonAssert json = this.jsonAssert(this.document, RenderingContext.CtxBuilder.enrichDoc((String[])new String[]{"breadcrumb"}).get());
        json = json.has("contextParameters").isObject();
        json.properties(1);
        json = json.has("breadcrumb").isObject();
        json.has("entity-type").isEquals("documents");
        json = json.has("entries").length(3);
        for (int i = 0; i < 3; ++i) {
            JsonAssert doc = json.has(i);
            doc.has("entity-type").isEquals("document");
            doc.has("title").isEquals("level" + (i + 1));
        }
    }
}

