/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.enrichers;

import java.util.HashMap;
import javax.inject.Inject;
import org.junit.Test;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriterTest;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.core.io.marshallers.json.document.DocumentModelJsonWriter;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@LocalDeploy(value={"org.nuxeo.ecm.core.io:OSGI-INF/doc-type-contrib.xml"})
public class ContextualParametersJsonEnricherTest
extends AbstractJsonWriterTest.Local<DocumentModelJsonWriter, DocumentModel> {
    @Inject
    private CoreSession session;

    public ContextualParametersJsonEnricherTest() {
        super(DocumentModelJsonWriter.class, DocumentModel.class);
    }

    @Test
    public void test() throws Exception {
        DocumentModel root = this.session.getDocument((DocumentRef)new PathRef("/"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("param1", "value1");
        params.put("param2", "value2");
        params.put("param3", "value3");
        RenderingContext ctx = RenderingContext.CtxBuilder.enrichDoc((String[])new String[]{"contextualParameters"}).param("contextualParameters", params).get();
        JsonAssert json = this.jsonAssert(root, ctx);
        json = json.has("contextParameters").isObject();
        json.properties(3);
        json.has("param1").isEquals("value1");
        json.has("param2").isEquals("value2");
        json.has("param3").isEquals("value3");
    }
}

