/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.types;

import javax.inject.Inject;
import org.junit.Test;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriterTest;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.core.io.marshallers.json.types.DocumentTypeJsonWriter;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;

public class DocumentTypeJsonWriterTest
extends AbstractJsonWriterTest.Local<DocumentTypeJsonWriter, DocumentType> {
    @Inject
    private SchemaManager schemaManager;

    public DocumentTypeJsonWriterTest() {
        super(DocumentTypeJsonWriter.class, DocumentType.class);
    }

    @Test
    public void test() throws Exception {
        DocumentType type = this.schemaManager.getDocumentType("Folder");
        JsonAssert json = this.jsonAssert(type);
        json.properties(5);
        json.has("entity-type").isEquals("docType");
        json.has("name").isEquals("Folder");
        json.has("parent").isEquals("Document");
        json.has("facets").contains("Folderish");
        json = json.has("schemas").length(2);
        json.childrenContains("entity-type", "schema", "schema");
        json.childrenContains("name", "common", "dublincore");
    }

    @Test
    public void testWithoutParent() throws Exception {
        DocumentType type = this.schemaManager.getDocumentType("Document");
        JsonAssert json = this.jsonAssert(type);
        json.properties(5);
        json.has("parent").isNull();
    }
}

