/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.types;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.junit.Test;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriterTest;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.core.io.marshallers.json.types.DocumentTypeListJsonWriter;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@LocalDeploy(value={"org.nuxeo.ecm.core.io:OSGI-INF/doc-type-contrib.xml"})
public class DocumentTypeListJsonWriterTest
extends AbstractJsonWriterTest.Local<DocumentTypeListJsonWriter, List<DocumentType>> {
    @Inject
    private SchemaManager schemaManager;

    public DocumentTypeListJsonWriterTest() {
        super(DocumentTypeListJsonWriter.class, DocumentType.class, TypeUtils.parameterize(List.class, (Type[])new Type[]{DocumentType.class}));
    }

    public List<DocumentType> getElements() {
        return Arrays.asList(this.schemaManager.getDocumentType("Folder"), this.schemaManager.getDocumentType("Document"));
    }

    @Test
    public void test() throws Exception {
        List<DocumentType> elements = this.getElements();
        JsonAssert json = this.jsonAssert(elements);
        json.isObject();
        json.properties(2);
        json.has("entity-type").isEquals("docTypes");
        json = json.has("entries").length(elements.size());
        json.childrenContains("entity-type", "docType", "docType");
        json.childrenContains("name", "Folder", "Document");
    }
}

