/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.types;

import javax.inject.Inject;
import org.junit.Test;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriterTest;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.core.io.marshallers.json.types.FacetJsonWriter;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.CompositeType;

public class FacetJsonWriterTest
extends AbstractJsonWriterTest.Local<FacetJsonWriter, CompositeType> {
    @Inject
    private SchemaManager schemaManager;

    public FacetJsonWriterTest() {
        super(FacetJsonWriter.class, CompositeType.class);
    }

    @Test
    public void testFacetWithoutSchema() throws Exception {
        CompositeType type = this.schemaManager.getFacet("Folderish");
        JsonAssert json = this.jsonAssert(type);
        json.properties(2);
        json.has("entity-type").isEquals("facet");
        json.has("name").isEquals("Folderish");
    }

    @Test
    public void testFacetWithSchema() throws Exception {
        CompositeType type = this.schemaManager.getFacet("HasRelatedText");
        JsonAssert json = this.jsonAssert(type);
        json.properties(3);
        json.has("entity-type").isEquals("facet");
        json.has("name").isEquals("HasRelatedText");
        json = json.has("schemas").length(1).has(0);
        json.has("entity-type").isEquals("schema");
        json.has("name").isEquals("relatedtext");
    }
}

