/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.types;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.junit.Test;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriterTest;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.core.io.marshallers.json.types.FacetListJsonWriter;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@LocalDeploy(value={"org.nuxeo.ecm.core.io:OSGI-INF/doc-type-contrib.xml"})
public class FacetListJsonWriterTest
extends AbstractJsonWriterTest.Local<FacetListJsonWriter, List<CompositeType>> {
    @Inject
    private SchemaManager schemaManager;

    public FacetListJsonWriterTest() {
        super(FacetListJsonWriter.class, List.class, TypeUtils.parameterize(List.class, (Type[])new Type[]{CompositeType.class}));
    }

    public List<CompositeType> getElements() {
        return Arrays.asList(this.schemaManager.getFacet("Folderish"), this.schemaManager.getFacet("Publishable"));
    }

    @Test
    public void test() throws Exception {
        List<CompositeType> elements = this.getElements();
        JsonAssert json = this.jsonAssert(elements);
        json.isObject();
        json.properties(2);
        json.has("entity-type").isEquals("facets");
        json = json.has("entries").length(elements.size());
        json.childrenContains("entity-type", "facet", "facet");
        json.childrenContains("name", "Folderish", "Publishable");
    }
}

