/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.types;

import javax.inject.Inject;
import org.junit.Test;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriterTest;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.core.io.marshallers.json.types.SchemaJsonWriter;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;

public class SchemaJsonWriterTest
extends AbstractJsonWriterTest.Local<SchemaJsonWriter, Schema> {
    @Inject
    private SchemaManager schemaManager;

    public SchemaJsonWriterTest() {
        super(SchemaJsonWriter.class, Schema.class);
    }

    @Test
    public void test() throws Exception {
        Schema schema = this.schemaManager.getSchema("dublincore");
        JsonAssert json = this.jsonAssert(schema);
        json.properties(4);
        json.has("entity-type").isEquals("schema");
        json.has("name").isEquals("dublincore");
        json.has("prefix").isEquals("dc");
        json = json.has("fields").properties(schema.getFieldsCount());
        json.has("contributors").isEquals("string[]");
        json.has("coverage").isEquals("string");
        json.has("created").isEquals("date");
        json.has("creator").isEquals("string");
        json.has("description").isEquals("string");
        json.has("expired").isEquals("date");
        json.has("format").isEquals("string");
        json.has("issued").isEquals("date");
        json.has("language").isEquals("string");
        json.has("lastContributor").isEquals("string");
        json.has("modified").isEquals("date");
        json.has("nature").isEquals("string");
        json.has("publisher").isEquals("string");
        json.has("rights").isEquals("string");
        json.has("source").isEquals("string");
        json.has("subjects").isEquals("string[]");
        json.has("title").isEquals("string");
        json.has("valid").isEquals("date");
    }

    @Test
    public void testSchemaWithoutPrefix() throws Exception {
        Schema schema = this.schemaManager.getSchema("common");
        JsonAssert json = this.jsonAssert(schema);
        json.properties(3);
        json.hasNot("prefix");
    }
}

