/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.types;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.junit.Test;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriterTest;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.core.io.marshallers.json.types.SchemaListJsonWriter;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@LocalDeploy(value={"org.nuxeo.ecm.core.io:OSGI-INF/doc-type-contrib.xml"})
public class SchemaListJsonWriterTest
extends AbstractJsonWriterTest.Local<SchemaListJsonWriter, List<Schema>> {
    @Inject
    private SchemaManager schemaManager;

    public SchemaListJsonWriterTest() {
        super(SchemaListJsonWriter.class, List.class, TypeUtils.parameterize(List.class, (Type[])new Type[]{Schema.class}));
    }

    public List<Schema> getElements() {
        return Arrays.asList(this.schemaManager.getSchema("dublincore"), this.schemaManager.getSchema("common"));
    }

    @Test
    public void test() throws Exception {
        List<Schema> elements = this.getElements();
        JsonAssert json = this.jsonAssert(elements);
        json.isObject();
        json.properties(2);
        json.has("entity-type").isEquals("schemas");
        json = json.has("entries").length(elements.size());
        json.childrenContains("entity-type", "schema", "schema");
        json.childrenContains("name", "dublincore", "common");
    }
}

