/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.validation;

import org.junit.Test;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriterTest;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.core.io.marshallers.json.validation.ConstraintJsonWriter;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;
import org.nuxeo.ecm.core.schema.types.constraints.NotNullConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.NumericIntervalConstraint;

public class ConstraintJsonWriterTest
extends AbstractJsonWriterTest.Local<ConstraintJsonWriter, Constraint> {
    public ConstraintJsonWriterTest() {
        super(ConstraintJsonWriter.class, Constraint.class);
    }

    @Test
    public void testWithParameters() throws Exception {
        NumericIntervalConstraint constraint = new NumericIntervalConstraint((Object)10, true, (Object)20, false);
        JsonAssert json = this.jsonAssert(constraint);
        json.properties(3);
        json.has("entity-type").isEquals("validation_constraint");
        json.has("name").isEquals("NumericIntervalConstraint");
        json = json.has("parameters").properties(4);
        json.has("Minimum").isEquals("10");
        json.has("MinimumInclusive").isEquals("true");
        json.has("Maximum").isEquals("20");
        json.has("MaximumInclusive").isEquals("false");
    }

    @Test
    public void testWithoutParameter() throws Exception {
        NotNullConstraint constraint = NotNullConstraint.get();
        JsonAssert json = this.jsonAssert(constraint);
        json = json.has("parameters").properties(0);
    }
}

