/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.junit.Test;
import org.nuxeo.ecm.core.api.validation.ConstraintViolation;
import org.nuxeo.ecm.core.api.validation.DocumentValidationReport;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriterTest;
import org.nuxeo.ecm.core.io.marshallers.json.JsonAssert;
import org.nuxeo.ecm.core.io.marshallers.json.validation.DocumentValidationReportJsonWriter;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;
import org.nuxeo.ecm.core.schema.types.constraints.NotNullConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.PatternConstraint;

public class DocumentValidationReportJsonWriterTest
extends AbstractJsonWriterTest.Local<DocumentValidationReportJsonWriter, DocumentValidationReport> {
    @Inject
    private SchemaManager schemaManager;

    public DocumentValidationReportJsonWriterTest() {
        super(DocumentValidationReportJsonWriter.class, DocumentValidationReport.class);
    }

    @Test
    public void test() throws Exception {
        Schema schema = this.schemaManager.getSchema("dublincore");
        Field title = schema.getField("title");
        List<ConstraintViolation.PathNode> titleNode = Arrays.asList(new ConstraintViolation.PathNode(title));
        ConstraintViolation violation1 = new ConstraintViolation(schema, titleNode, (Constraint)NotNullConstraint.get(), null);
        Field description = schema.getField("description");
        List<ConstraintViolation.PathNode> descNode = Arrays.asList(new ConstraintViolation.PathNode(description));
        ConstraintViolation violation2 = new ConstraintViolation(schema, descNode, (Constraint)new PatternConstraint(".*"), null);
        DocumentValidationReport report = new DocumentValidationReport(Arrays.asList(violation1, violation2));
        JsonAssert json = this.jsonAssert(report);
        json.properties(4);
        json.has("entity-type").isEquals("validation_report");
        json.has("has_error").isTrue();
        json.has("number").isEquals(2);
        json = json.has("violations").length(2);
        json.has(0).properties(4).has("message").isText();
        json.has(1).properties(4).has("message").isText();
        json.childrenContains("invalid_value", null, null);
        json.childrenContains("constraint.entity-type", "validation_constraint", "validation_constraint");
        json.childrenContains("constraint.name", "NotNullConstraint", "PatternConstraint");
        json.childrenContains("path.field_name", "dc:title", "dc:description");
        json.childrenContains("path.is_list_item", "false", "false");
    }

    @Test
    public void testNoErrors() throws Exception {
        DocumentValidationReport report = new DocumentValidationReport(new ArrayList());
        JsonAssert json = this.jsonAssert(report);
        json.properties(4);
        json.has("entity-type").isEquals("validation_report");
        json.has("has_error").isFalse();
        json.has("number").isEquals(0);
        json = json.has("violations").length(0);
    }
}

