/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.registry;

import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.io.registry.MarshallerRegistry;
import org.nuxeo.ecm.core.io.registry.MarshallingException;
import org.nuxeo.ecm.core.io.registry.Reader;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.io.registry.reflect.Supports;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Deploy(value={"org.nuxeo.ecm.core.io:OSGI-INF/MarshallerRegistry.xml"})
@Features(value={CoreFeature.class})
public class TestReaderRegistry {
    private RenderingContext ctx;
    private MarshallerRegistry registry;
    private Map<String, List<Integer>> listIntegerMapProperty = null;
    private Map<String, List<?>> listMapProperty = null;
    private Map<?, ?> mapProperty = null;

    @Before
    public void setup() {
        this.ctx = RenderingContext.CtxBuilder.get();
        this.registry = (MarshallerRegistry)Framework.getService(MarshallerRegistry.class);
        this.registry.clear();
    }

    @Test(expected=MarshallingException.class)
    public void registerInvalidReader() throws Exception {
        this.registry.register(InvalidReader.class);
    }

    @Test(expected=MarshallingException.class)
    public void registerClassNotSupported() throws Exception {
        this.registry.register(NotSupportedClass.class);
    }

    @Test
    public void simpleRegistering() throws Exception {
        this.registry.register(DefaultNumberReader.class);
        Reader Reader2 = this.registry.getReader(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNotNull((Object)Reader2);
        Assert.assertEquals(DefaultNumberReader.class, Reader2.getClass());
    }

    @Test
    public void registerTwice() throws Exception {
        this.registry.register(DefaultNumberReader.class);
        this.registry.register(DefaultNumberReader.class);
        Reader Reader2 = this.registry.getReader(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberReader.class, Reader2.getClass());
    }

    @Test
    public void priorities() throws Exception {
        this.registry.register(DefaultNumberReader.class);
        this.registry.register(LowerPriorityReader.class);
        Reader Reader2 = this.registry.getReader(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberReader.class, Reader2.getClass());
        this.registry.register(HigherPriorityReader.class);
        Reader2 = this.registry.getReader(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(HigherPriorityReader.class, Reader2.getClass());
    }

    @Test
    public void prioriseSingletonToPerThreadToEachTime() throws Exception {
        this.registry.register(EachTimeReader.class);
        this.registry.register(PerThreadReader.class);
        Reader Reader2 = this.registry.getReader(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(PerThreadReader.class, Reader2.getClass());
        this.registry.register(DefaultNumberReader.class);
        Reader2 = this.registry.getReader(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberReader.class, Reader2.getClass());
        this.registry.clear();
        this.registry.register(PerThreadReader.class);
        this.registry.register(DefaultNumberReader.class);
        Reader2 = this.registry.getReader(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberReader.class, Reader2.getClass());
        this.registry.register(LowerPriorityReader.class);
        Reader2 = this.registry.getReader(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberReader.class, Reader2.getClass());
    }

    @Test
    public void prioriseParentClasses() throws Exception {
        this.registry.register(DefaultNumberReader.class);
        this.registry.register(SubClassReader.class);
        Reader Reader2 = this.registry.getReader(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberReader.class, Reader2.getClass());
        this.registry.clear();
        this.registry.register(SubClassReader.class);
        this.registry.register(DefaultNumberReader.class);
        Reader2 = this.registry.getReader(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberReader.class, Reader2.getClass());
    }

    @Test
    public void byMediaType() throws Exception {
        this.registry.register(AnyTypeReader.class);
        Reader Reader2 = this.registry.getReader(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(AnyTypeReader.class, Reader2.getClass());
        this.registry.register(DefaultNumberReader.class);
        Reader2 = this.registry.getReader(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberReader.class, Reader2.getClass());
        this.registry.register(XmlReader.class);
        Reader2 = this.registry.getReader(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberReader.class, Reader2.getClass());
        Reader2 = this.registry.getReader(this.ctx, Integer.class, null, MediaType.TEXT_XML_TYPE);
        Assert.assertEquals(XmlReader.class, Reader2.getClass());
        this.registry.clear();
        this.registry.register(DefaultNumberReader.class);
        Reader2 = this.registry.getReader(this.ctx, Integer.class, null, MediaType.WILDCARD_TYPE);
        Assert.assertEquals(DefaultNumberReader.class, Reader2.getClass());
    }

    @Test
    public void ensureAcceptMethodIsCalled() throws Exception {
        this.registry.register(SingletonStateReader.class);
        this.registry.register(DefaultNumberReader.class);
        Reader Reader2 = this.registry.getReader(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(SingletonStateReader.class, Reader2.getClass());
        RenderingContext ctx2 = RenderingContext.CtxBuilder.param((String)"doNotAccept", (Object)true).get();
        Reader2 = this.registry.getReader(ctx2, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberReader.class, Reader2.getClass());
    }

    @Test
    public void genericTypeChecking() throws Exception {
        Type listIntegerMap = TestReaderRegistry.class.getDeclaredField("listIntegerMapProperty").getGenericType();
        Type listMap = TestReaderRegistry.class.getDeclaredField("listMapProperty").getGenericType();
        Type map = TestReaderRegistry.class.getDeclaredField("mapProperty").getGenericType();
        this.registry.register(ListIntegerMapReader.class);
        Reader Reader2 = this.registry.getReader(this.ctx, Map.class, listIntegerMap, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNotNull((Object)Reader2);
        Assert.assertEquals(Reader2.getClass(), ListIntegerMapReader.class);
        Reader2 = this.registry.getReader(this.ctx, Map.class, listMap, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNull((Object)Reader2);
        Reader2 = this.registry.getReader(this.ctx, Map.class, map, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNull((Object)Reader2);
        this.registry.register(ListMapReader.class);
        Reader2 = this.registry.getReader(this.ctx, Map.class, listIntegerMap, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNotNull((Object)Reader2);
        Reader2 = this.registry.getReader(this.ctx, Map.class, listMap, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNotNull((Object)Reader2);
        Assert.assertEquals(Reader2.getClass(), ListMapReader.class);
        Reader2 = this.registry.getReader(this.ctx, Map.class, map, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNull((Object)Reader2);
        this.registry.register(MapReader.class);
        Reader2 = this.registry.getReader(this.ctx, Map.class, listIntegerMap, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNotNull((Object)Reader2);
        Reader2 = this.registry.getReader(this.ctx, Map.class, listMap, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNotNull((Object)Reader2);
        Reader2 = this.registry.getReader(this.ctx, Map.class, map, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNotNull((Object)Reader2);
        Assert.assertEquals(Reader2.getClass(), MapReader.class);
    }

    @Setup(mode=Instantiations.SINGLETON)
    @Supports(value={"application/json"})
    public static class MapReader
    implements Reader<Map<?, ?>> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public Map<?, ?> read(Class<?> clazz, Type genericType, MediaType mediatype, InputStream in) {
            return null;
        }
    }

    @Setup(mode=Instantiations.SINGLETON)
    @Supports(value={"application/json"})
    public static class ListMapReader
    implements Reader<Map<?, List<?>>> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public Map<?, List<?>> read(Class<?> clazz, Type genericType, MediaType mediatype, InputStream in) {
            return null;
        }
    }

    @Setup(mode=Instantiations.SINGLETON)
    @Supports(value={"application/json"})
    public static class ListIntegerMapReader
    implements Reader<Map<String, List<Integer>>> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public Map<String, List<Integer>> read(Class<?> clazz, Type genericType, MediaType mediatype, InputStream in) {
            return null;
        }
    }

    @Setup(mode=Instantiations.SINGLETON, priority=2000)
    @Supports(value={"*/*"})
    public static class AnyTypeReader
    extends DefaultNumberReader {
    }

    @Setup(mode=Instantiations.SINGLETON, priority=2000)
    @Supports(value={"text/xml"})
    public static class XmlReader
    extends DefaultNumberReader {
    }

    @Setup(mode=Instantiations.SINGLETON, priority=1000)
    public static class EachTimeReader
    extends DefaultNumberReader {
    }

    @Setup(mode=Instantiations.SINGLETON, priority=1000)
    public static class PerThreadReader
    extends DefaultNumberReader {
    }

    @Setup(mode=Instantiations.SINGLETON, priority=1000)
    public static class LowerPriorityReader
    extends DefaultNumberReader {
    }

    @Setup(mode=Instantiations.SINGLETON, priority=3000)
    public static class HigherPriorityReader
    extends DefaultNumberReader {
    }

    @Setup(mode=Instantiations.SINGLETON, priority=2000)
    public static class SubClassReader
    extends DefaultNumberReader {
    }

    @Setup(mode=Instantiations.SINGLETON, priority=3000)
    public static class SingletonStateReader
    extends DefaultNumberReader {
        @Inject
        RenderingContext ctx;

        @Override
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return !this.ctx.getBooleanParameter("doNotAccept");
        }
    }

    @Setup(mode=Instantiations.SINGLETON, priority=2000)
    @Supports(value={"application/json"})
    public static class DefaultNumberReader
    implements Reader<Number> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public Number read(Class<?> clazz, Type genericType, MediaType mediatype, InputStream in) {
            return null;
        }
    }

    @Setup(mode=Instantiations.SINGLETON, priority=2000)
    @Supports(value={"application/json"})
    public static class NotSupportedClass {
    }

    public static class InvalidReader
    implements Reader<Object> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public Object read(Class<?> clazz, Type genericType, MediaType mediatype, InputStream in) {
            return null;
        }
    }
}

