/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.registry;

import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.io.registry.MarshallerRegistry;
import org.nuxeo.ecm.core.io.registry.MarshallingException;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.io.registry.reflect.Supports;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Deploy(value={"org.nuxeo.ecm.core.io:OSGI-INF/MarshallerRegistry.xml"})
@Features(value={CoreFeature.class})
public class TestWriterRegistry {
    private RenderingContext ctx;
    private MarshallerRegistry registry;
    private Map<String, List<Integer>> listIntegerMapProperty = null;
    private Map<String, List<?>> listMapProperty = null;
    private Map<?, ?> mapProperty = null;

    @Before
    public void setup() {
        this.ctx = RenderingContext.CtxBuilder.get();
        this.registry = (MarshallerRegistry)Framework.getService(MarshallerRegistry.class);
        this.registry.clear();
    }

    @Test(expected=MarshallingException.class)
    public void registerInvalidWriter() throws Exception {
        this.registry.register(InvalidWriter.class);
    }

    @Test(expected=MarshallingException.class)
    public void registerClassNotSupported() throws Exception {
        this.registry.register(NotSupportedClass.class);
    }

    @Test
    public void simpleRegistering() throws Exception {
        this.registry.register(DefaultNumberWriter.class);
        Writer writer = this.registry.getWriter(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNotNull((Object)writer);
        Assert.assertEquals(DefaultNumberWriter.class, writer.getClass());
    }

    @Test
    public void registerTwice() throws Exception {
        this.registry.register(DefaultNumberWriter.class);
        this.registry.register(DefaultNumberWriter.class);
        Writer writer = this.registry.getWriter(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberWriter.class, writer.getClass());
    }

    @Test
    public void priorities() throws Exception {
        this.registry.register(DefaultNumberWriter.class);
        this.registry.register(LowerPriorityWriter.class);
        Writer writer = this.registry.getWriter(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberWriter.class, writer.getClass());
        this.registry.register(HigherPriorityWriter.class);
        writer = this.registry.getWriter(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(HigherPriorityWriter.class, writer.getClass());
    }

    @Test
    public void prioriseSingletonToPerThreadToEachTime() throws Exception {
        this.registry.register(EachTimeWriter.class);
        this.registry.register(PerThreadWriter.class);
        Writer writer = this.registry.getWriter(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(PerThreadWriter.class, writer.getClass());
        this.registry.register(DefaultNumberWriter.class);
        writer = this.registry.getWriter(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberWriter.class, writer.getClass());
        this.registry.clear();
        this.registry.register(PerThreadWriter.class);
        this.registry.register(DefaultNumberWriter.class);
        writer = this.registry.getWriter(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberWriter.class, writer.getClass());
        this.registry.register(LowerPriorityWriter.class);
        writer = this.registry.getWriter(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberWriter.class, writer.getClass());
    }

    @Test
    public void prioriseParentClasses() throws Exception {
        this.registry.register(DefaultNumberWriter.class);
        this.registry.register(SubClassWriter.class);
        Writer writer = this.registry.getWriter(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberWriter.class, writer.getClass());
        this.registry.clear();
        this.registry.register(SubClassWriter.class);
        this.registry.register(DefaultNumberWriter.class);
        writer = this.registry.getWriter(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberWriter.class, writer.getClass());
    }

    @Test
    public void byMediaType() throws Exception {
        this.registry.register(AnyTypeWriter.class);
        Writer writer = this.registry.getWriter(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(AnyTypeWriter.class, writer.getClass());
        this.registry.register(DefaultNumberWriter.class);
        writer = this.registry.getWriter(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberWriter.class, writer.getClass());
        this.registry.register(XmlWriter.class);
        writer = this.registry.getWriter(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberWriter.class, writer.getClass());
        writer = this.registry.getWriter(this.ctx, Integer.class, null, MediaType.TEXT_XML_TYPE);
        Assert.assertEquals(XmlWriter.class, writer.getClass());
        this.registry.clear();
        this.registry.register(DefaultNumberWriter.class);
        writer = this.registry.getWriter(this.ctx, Integer.class, null, MediaType.WILDCARD_TYPE);
        Assert.assertEquals(DefaultNumberWriter.class, writer.getClass());
    }

    @Test
    public void ensureAcceptMethodIsCalled() throws Exception {
        this.registry.register(SingletonStateWriter.class);
        this.registry.register(DefaultNumberWriter.class);
        Writer writer = this.registry.getWriter(this.ctx, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(SingletonStateWriter.class, writer.getClass());
        RenderingContext ctx2 = RenderingContext.CtxBuilder.param((String)"doNotAccept", (Object)true).get();
        writer = this.registry.getWriter(ctx2, Integer.class, null, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals(DefaultNumberWriter.class, writer.getClass());
    }

    @Test
    public void genericTypeChecking() throws Exception {
        Type listIntegerMap = TestWriterRegistry.class.getDeclaredField("listIntegerMapProperty").getGenericType();
        Type listMap = TestWriterRegistry.class.getDeclaredField("listMapProperty").getGenericType();
        Type map = TestWriterRegistry.class.getDeclaredField("mapProperty").getGenericType();
        this.registry.register(ListIntegerMapWriter.class);
        Writer writer = this.registry.getWriter(this.ctx, Map.class, listIntegerMap, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNotNull((Object)writer);
        Assert.assertEquals(writer.getClass(), ListIntegerMapWriter.class);
        writer = this.registry.getWriter(this.ctx, Map.class, listMap, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNull((Object)writer);
        writer = this.registry.getWriter(this.ctx, Map.class, map, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNull((Object)writer);
        this.registry.register(ListMapWriter.class);
        writer = this.registry.getWriter(this.ctx, Map.class, listIntegerMap, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNotNull((Object)writer);
        writer = this.registry.getWriter(this.ctx, Map.class, listMap, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNotNull((Object)writer);
        Assert.assertEquals(writer.getClass(), ListMapWriter.class);
        writer = this.registry.getWriter(this.ctx, Map.class, map, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNull((Object)writer);
        this.registry.register(MapWriter.class);
        writer = this.registry.getWriter(this.ctx, Map.class, listIntegerMap, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNotNull((Object)writer);
        writer = this.registry.getWriter(this.ctx, Map.class, listMap, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNotNull((Object)writer);
        writer = this.registry.getWriter(this.ctx, Map.class, map, MediaType.APPLICATION_JSON_TYPE);
        Assert.assertNotNull((Object)writer);
        Assert.assertEquals(writer.getClass(), MapWriter.class);
    }

    @Setup(mode=Instantiations.SINGLETON)
    @Supports(value={"application/json"})
    public static class MapWriter
    implements Writer<Map<?, ?>> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public void write(Map<?, ?> entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) {
        }
    }

    @Setup(mode=Instantiations.SINGLETON)
    @Supports(value={"application/json"})
    public static class ListMapWriter
    implements Writer<Map<?, List<?>>> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public void write(Map<?, List<?>> entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) {
        }
    }

    @Setup(mode=Instantiations.SINGLETON)
    @Supports(value={"application/json"})
    public static class ListIntegerMapWriter
    implements Writer<Map<String, List<Integer>>> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public void write(Map<String, List<Integer>> entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) {
        }
    }

    @Setup(mode=Instantiations.SINGLETON, priority=2000)
    @Supports(value={"*/*"})
    public static class AnyTypeWriter
    extends DefaultNumberWriter {
    }

    @Setup(mode=Instantiations.SINGLETON, priority=2000)
    @Supports(value={"text/xml"})
    public static class XmlWriter
    extends DefaultNumberWriter {
    }

    @Setup(mode=Instantiations.SINGLETON, priority=1000)
    public static class EachTimeWriter
    extends DefaultNumberWriter {
    }

    @Setup(mode=Instantiations.SINGLETON, priority=1000)
    public static class PerThreadWriter
    extends DefaultNumberWriter {
    }

    @Setup(mode=Instantiations.SINGLETON, priority=1000)
    public static class LowerPriorityWriter
    extends DefaultNumberWriter {
    }

    @Setup(mode=Instantiations.SINGLETON, priority=3000)
    public static class HigherPriorityWriter
    extends DefaultNumberWriter {
    }

    @Setup(mode=Instantiations.SINGLETON, priority=2000)
    public static class SubClassWriter
    extends DefaultNumberWriter {
    }

    @Setup(mode=Instantiations.SINGLETON, priority=3000)
    public static class SingletonStateWriter
    extends DefaultNumberWriter {
        @Inject
        RenderingContext ctx;

        @Override
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return !this.ctx.getBooleanParameter("doNotAccept");
        }
    }

    @Setup(mode=Instantiations.SINGLETON, priority=2000)
    @Supports(value={"application/json"})
    public static class DefaultNumberWriter
    implements Writer<Number> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public void write(Number entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) {
        }
    }

    @Setup(mode=Instantiations.SINGLETON, priority=2000)
    @Supports(value={"application/json"})
    public static class NotSupportedClass {
    }

    public static class InvalidWriter
    implements Writer<Object> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public void write(Object entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) {
        }
    }
}

