/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.registry.context;

import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;

public class TestRenderingContext {
    private static final String VALUE1 = "value1";
    private static final String VALUE2 = "value2";
    private static final String VALUE3 = "value3";
    private static final String PARAM = "test";

    @Test
    public void emptyContext() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.get();
        Assert.assertEquals((Object)"http://fake-url.nuxeo.com/", (Object)ctx.getBaseUrl());
        Assert.assertEquals((Object)RenderingContext.DEFAULT_LOCALE, (Object)ctx.getLocale());
        Assert.assertTrue((boolean)ctx.getAllParameters().isEmpty());
    }

    @Test
    public void canSetAndGetSimpleParameter() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.param((String)PARAM, (Object)VALUE1).get();
        Assert.assertEquals((Object)VALUE1, (Object)ctx.getParameter(PARAM));
    }

    @Test
    public void canSetAndGetMultipleParameters() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.paramValues((String)PARAM, (Object[])new Object[]{VALUE1, VALUE2}).get();
        List list = ctx.getParameters(PARAM);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(VALUE1));
        Assert.assertTrue((boolean)list.contains(VALUE2));
    }

    @Test
    public void getQuoteSeparatedNxParam() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.param((String)"properties", (Object)"value1,value2").get();
        Set embeds = ctx.getProperties();
        Assert.assertNotNull((Object)embeds);
        Assert.assertEquals((long)2L, (long)embeds.size());
        Assert.assertTrue((boolean)embeds.contains(VALUE1));
        Assert.assertTrue((boolean)embeds.contains(VALUE2));
    }

    @Test
    public void getMultipleNxParam() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.param((String)"properties", (Object)VALUE1).param("properties", (Object)VALUE2).get();
        Set embeds = ctx.getProperties();
        Assert.assertNotNull((Object)embeds);
        Assert.assertEquals((long)2L, (long)embeds.size());
        Assert.assertTrue((boolean)embeds.contains(VALUE1));
        Assert.assertTrue((boolean)embeds.contains(VALUE2));
    }

    @Test
    public void getPrefixedNxParam() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.param((String)"X-NXproperties", (Object)VALUE1).param("X-NXproperties", (Object)VALUE2).get();
        Set embeds = ctx.getProperties();
        Assert.assertNotNull((Object)embeds);
        Assert.assertEquals((long)2L, (long)embeds.size());
        Assert.assertTrue((boolean)embeds.contains(VALUE1));
        Assert.assertTrue((boolean)embeds.contains(VALUE2));
    }

    @Test
    public void getMixedNxParam() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.param((String)"properties", (Object)"value1,value2").param("X-NXproperties", (Object)VALUE3).get();
        Set embeds = ctx.getProperties();
        Assert.assertNotNull((Object)embeds);
        Assert.assertEquals((long)3L, (long)embeds.size());
        Assert.assertTrue((boolean)embeds.contains(VALUE1));
        Assert.assertTrue((boolean)embeds.contains(VALUE2));
        Assert.assertTrue((boolean)embeds.contains(VALUE3));
    }

    @Test
    public void nxParamBackwardCompatPropertiesHeader() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.param((String)"X-NXDocumentProperties", (Object)"value1,value2").get();
        Set embeds = ctx.getProperties();
        Assert.assertNotNull((Object)embeds);
        Assert.assertEquals((long)2L, (long)embeds.size());
        Assert.assertTrue((boolean)embeds.contains(VALUE1));
        Assert.assertTrue((boolean)embeds.contains(VALUE2));
    }

    @Test
    public void nxParamBackwardCompatEnricherHeader() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.param((String)"X-NXContext-Category", (Object)"value1,value2").get();
        Set embeds = ctx.getEnrichers("document");
        Assert.assertNotNull((Object)embeds);
        Assert.assertEquals((long)2L, (long)embeds.size());
        Assert.assertTrue((boolean)embeds.contains(VALUE1));
        Assert.assertTrue((boolean)embeds.contains(VALUE2));
    }
}

