/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.registry.context;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;

public class TestRenderingContextBuilder {
    private static final String VALUE1 = "value1";
    private static final String VALUE2 = "value2";
    private static final String PARAM = "test";

    @Test
    public void emptyContext() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.get();
        Assert.assertNotNull((Object)ctx);
        Assert.assertEquals((Object)"http://fake-url.nuxeo.com/", (Object)ctx.getBaseUrl());
        Assert.assertEquals((Object)RenderingContext.DEFAULT_LOCALE, (Object)ctx.getLocale());
        Map allParameters = ctx.getAllParameters();
        Assert.assertNotNull((Object)allParameters);
        Assert.assertTrue((boolean)allParameters.isEmpty());
    }

    @Test
    public void simpleContext() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.base((String)"url").locale(Locale.FRANCE).param(PARAM, (Object)VALUE1).param(PARAM, (Object)VALUE2).get();
        Assert.assertEquals((Object)"url", (Object)ctx.getBaseUrl());
        Assert.assertEquals((Object)Locale.FRANCE, (Object)ctx.getLocale());
        Map allParameters = ctx.getAllParameters();
        Assert.assertEquals((long)1L, (long)allParameters.size());
        List values = (List)allParameters.get(PARAM);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertTrue((boolean)values.contains(VALUE1));
        Assert.assertTrue((boolean)values.contains(VALUE2));
    }

    @Test
    public void testDocProperties() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.properties((String[])new String[]{"one,two, three"}).properties(new String[]{"four"}).param("X-NXDocumentProperties", (Object)" five , six").get();
        Set properties = ctx.getProperties();
        Assert.assertEquals((long)6L, (long)properties.size());
        Assert.assertTrue((boolean)properties.contains("one"));
        Assert.assertTrue((boolean)properties.contains("two"));
        Assert.assertTrue((boolean)properties.contains("three"));
        Assert.assertTrue((boolean)properties.contains("four"));
        Assert.assertTrue((boolean)properties.contains("five"));
        Assert.assertTrue((boolean)properties.contains("six"));
    }

    @Test
    public void testEnrichment() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.enrich((String)"document", (String[])new String[]{"one,two, three"}).enrichDoc(new String[]{"four"}).param("X-NXContext-Category", (Object)" five , six").get();
        Set properties = ctx.getEnrichers("document");
        Assert.assertEquals((long)6L, (long)properties.size());
        Assert.assertTrue((boolean)properties.contains("one"));
        Assert.assertTrue((boolean)properties.contains("two"));
        Assert.assertTrue((boolean)properties.contains("three"));
        Assert.assertTrue((boolean)properties.contains("four"));
        Assert.assertTrue((boolean)properties.contains("five"));
        Assert.assertTrue((boolean)properties.contains("six"));
    }

    @Test
    public void testFetchedProperties() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.fetchInDoc((String[])new String[]{"one,two, three"}).fetch("document", new String[]{"four"}).param("fetch.document", (Object)" five , six").get();
        Set properties = ctx.getFetched("document");
        Assert.assertEquals((long)6L, (long)properties.size());
        Assert.assertTrue((boolean)properties.contains("one"));
        Assert.assertTrue((boolean)properties.contains("two"));
        Assert.assertTrue((boolean)properties.contains("three"));
        Assert.assertTrue((boolean)properties.contains("four"));
        Assert.assertTrue((boolean)properties.contains("five"));
        Assert.assertTrue((boolean)properties.contains("six"));
    }
}

