/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.registry.context;

import java.io.Closeable;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.core.io.registry.context.DepthValues;
import org.nuxeo.ecm.core.io.registry.context.MaxDepthReachedException;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;

public class TestWrappedContext {
    private static final String VALUE1 = "value1";
    private static final String VALUE2 = "value2";
    private static final String PARAM = "test";

    @Test
    public void noContext() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.get();
        Assert.assertNull((Object)ctx.getParameter(PARAM));
    }

    @Test
    public void emptyContext() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.get();
        try (Closeable wrapped = ctx.wrap().open();){
            Assert.assertNull((Object)ctx.getParameter(PARAM));
        }
    }

    @Test
    public void simpleParam() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.get();
        try (Closeable wrapped = ctx.wrap().with(PARAM, (Object)VALUE1).open();){
            Object value = ctx.getParameter(PARAM);
            Assert.assertNotNull((Object)value);
            Assert.assertEquals((Object)VALUE1, (Object)value);
        }
    }

    @Test
    public void subContext() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.get();
        try (Closeable wrapped = ctx.wrap().with(PARAM, (Object)VALUE1).open();){
            Object value = ctx.getParameter(PARAM);
            Assert.assertNotNull((Object)value);
            Assert.assertEquals((Object)VALUE1, (Object)value);
            try (Closeable wrapped2 = ctx.wrap().with(PARAM, (Object)VALUE2).open();){
                value = ctx.getParameter(PARAM);
                Assert.assertNotNull((Object)value);
                Assert.assertEquals((Object)VALUE2, (Object)value);
            }
            value = ctx.getParameter(PARAM);
            Assert.assertNotNull((Object)value);
            Assert.assertEquals((Object)VALUE1, (Object)value);
        }
    }

    @Test
    public void basicParameterOverridesWrapped() throws Exception {
        RenderingContext ctx = RenderingContext.CtxBuilder.param((String)PARAM, (Object)VALUE2).get();
        try (Closeable wrapped = ctx.wrap().with(PARAM, (Object)VALUE1).open();){
            Object value = ctx.getParameter(PARAM);
            Assert.assertNotNull((Object)value);
            Assert.assertEquals((Object)VALUE2, (Object)value);
        }
    }

    @Test
    public void testControlDepthDefaultIsRoot() throws IOException {
        RenderingContext ctx = RenderingContext.CtxBuilder.get();
        try (Closeable wrappedRoot = ctx.wrap().controlDepth().open();){
            try (Closeable wrappedChild = ctx.wrap().controlDepth().open();){
                Assert.fail();
            }
            catch (MaxDepthReachedException maxDepthReachedException) {
                // empty catch block
            }
        }
        catch (MaxDepthReachedException mdre) {
            Assert.fail();
        }
    }

    @Test
    public void testRootControlDepth() throws IOException {
        RenderingContext ctx = RenderingContext.CtxBuilder.depth((DepthValues)DepthValues.root).get();
        try (Closeable wrappedRoot = ctx.wrap().controlDepth().open();){
            try (Closeable wrappedChild = ctx.wrap().controlDepth().open();){
                Assert.fail();
            }
            catch (MaxDepthReachedException maxDepthReachedException) {
                // empty catch block
            }
        }
        catch (MaxDepthReachedException mdre) {
            Assert.fail();
        }
    }

    @Test
    public void testChildControlDepth() throws IOException {
        RenderingContext ctx = RenderingContext.CtxBuilder.depth((DepthValues)DepthValues.children).get();
        try (Closeable wrappedRoot = ctx.wrap().controlDepth().open();){
            try (Closeable wrappedChild = ctx.wrap().controlDepth().open();){
                try (Closeable wrappedMax = ctx.wrap().controlDepth().open();){
                    Assert.fail();
                }
                catch (MaxDepthReachedException maxDepthReachedException) {
                    // empty catch block
                }
            }
            catch (MaxDepthReachedException mdre) {
                Assert.fail();
            }
        }
        catch (MaxDepthReachedException mdre) {
            Assert.fail();
        }
    }

    @Test
    public void testMaxControlDepth() throws IOException {
        RenderingContext ctx = RenderingContext.CtxBuilder.depth((DepthValues)DepthValues.max).get();
        try (Closeable wrappedRoot = ctx.wrap().controlDepth().open();){
            try (Closeable wrappedChild = ctx.wrap().controlDepth().open();){
                try (Closeable wrappedMax = ctx.wrap().controlDepth().open();){
                    try (Closeable wrappedOver = ctx.wrap().controlDepth().open();){
                        Assert.fail();
                    }
                    catch (MaxDepthReachedException maxDepthReachedException) {
                        // empty catch block
                    }
                }
                catch (MaxDepthReachedException mdre) {
                    Assert.fail();
                }
            }
            catch (MaxDepthReachedException mdre) {
                Assert.fail();
            }
        }
        catch (MaxDepthReachedException mdre) {
            Assert.fail();
        }
    }
}

