/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.registry.reflect;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.context.ThreadSafeRenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.MarshallerInspector;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;

public class TestContextInjection {
    private final RenderingContext ctx = RenderingContext.CtxBuilder.get();

    @Test
    public void noInjectionIfNoAnnotation() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(NoInjectionMarshaller.class);
        NoInjectionMarshaller instance = (NoInjectionMarshaller)inspector.getInstance(this.ctx);
        Assert.assertNull((Object)instance.ctx);
    }

    @Test
    public void ifNullContextInjectEmptyContext() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(SingletonMarshaller.class);
        SingletonMarshaller instance = (SingletonMarshaller)inspector.getInstance(null);
        Assert.assertNotNull((Object)instance.ctx);
        Assert.assertTrue((boolean)instance.ctx.getAllParameters().isEmpty());
    }

    @Test
    public void ifThreadSafeContextInjectDelegateContext() throws Exception {
        ThreadSafeRenderingContext tsCtx = new ThreadSafeRenderingContext();
        tsCtx.configureThread(this.ctx);
        MarshallerInspector inspector = new MarshallerInspector(EachTimeMarshaller.class);
        EachTimeMarshaller instance = (EachTimeMarshaller)inspector.getInstance((RenderingContext)tsCtx);
        Assert.assertNotNull((Object)instance.ctx);
        Assert.assertSame((Object)this.ctx, (Object)instance.ctx);
    }

    @Test
    public void injectInEachTimeInstance() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(EachTimeMarshaller.class);
        EachTimeMarshaller instance = (EachTimeMarshaller)inspector.getInstance(this.ctx);
        Assert.assertSame((Object)this.ctx, (Object)instance.ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void injectInPerThreadInstance() throws Exception {
        final MarshallerInspector inspector = new MarshallerInspector(PerThreadMarshaller.class);
        PerThreadMarshaller instance1 = (PerThreadMarshaller)inspector.getInstance(this.ctx);
        Assert.assertSame((Object)this.ctx, (Object)instance1.ctx);
        Thread subThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    PerThreadMarshaller instance2 = (PerThreadMarshaller)inspector.getInstance(TestContextInjection.this.ctx);
                    Assert.assertSame((Object)TestContextInjection.this.ctx, (Object)instance2.ctx);
                    this.notify();
                }
            }
        };
        subThread.start();
        Thread thread = subThread;
        synchronized (thread) {
            subThread.wait();
        }
    }

    @Test
    public void replaceContextInPerThreadInstance() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(PerThreadMarshaller.class);
        PerThreadMarshaller instance1 = (PerThreadMarshaller)inspector.getInstance(this.ctx);
        RenderingContext ctx2 = RenderingContext.CtxBuilder.get();
        PerThreadMarshaller instance2 = (PerThreadMarshaller)inspector.getInstance(ctx2);
        Assert.assertSame((Object)ctx2, (Object)instance1.ctx);
        Assert.assertSame((Object)ctx2, (Object)instance2.ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void injectInSingletonInstance() throws Exception {
        final MarshallerInspector inspector = new MarshallerInspector(SingletonMarshaller.class);
        SingletonMarshaller instance1 = (SingletonMarshaller)inspector.getInstance(this.ctx);
        Assert.assertNotSame((Object)this.ctx, (Object)instance1.ctx);
        Assert.assertTrue((boolean)(instance1.ctx instanceof ThreadSafeRenderingContext));
        ThreadSafeRenderingContext safeCtx = (ThreadSafeRenderingContext)instance1.ctx;
        Assert.assertNotNull((Object)safeCtx.getDelegate());
        Assert.assertSame((Object)this.ctx, (Object)safeCtx.getDelegate());
        Thread subThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    SingletonMarshaller instance2 = (SingletonMarshaller)inspector.getInstance(TestContextInjection.this.ctx);
                    Assert.assertNotSame((Object)TestContextInjection.this.ctx, (Object)instance2.ctx);
                    Assert.assertTrue((boolean)(instance2.ctx instanceof ThreadSafeRenderingContext));
                    ThreadSafeRenderingContext safeCtx = (ThreadSafeRenderingContext)instance2.ctx;
                    Assert.assertNotNull((Object)safeCtx.getDelegate());
                    Assert.assertSame((Object)TestContextInjection.this.ctx, (Object)safeCtx.getDelegate());
                    this.notify();
                }
            }
        };
        subThread.start();
        Thread thread = subThread;
        synchronized (thread) {
            subThread.wait();
        }
    }

    @Test
    public void replaceContextInSingletonInstance() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(SingletonMarshaller.class);
        SingletonMarshaller instance1 = (SingletonMarshaller)inspector.getInstance(this.ctx);
        RenderingContext ctx2 = RenderingContext.CtxBuilder.get();
        SingletonMarshaller instance2 = (SingletonMarshaller)inspector.getInstance(ctx2);
        ThreadSafeRenderingContext safeCtx1 = (ThreadSafeRenderingContext)instance1.ctx;
        ThreadSafeRenderingContext safeCtx2 = (ThreadSafeRenderingContext)instance2.ctx;
        Assert.assertSame((Object)ctx2, (Object)safeCtx1.getDelegate());
        Assert.assertSame((Object)ctx2, (Object)safeCtx2.getDelegate());
    }

    @Test
    public void inheritInjection() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(InheritMarshaller.class);
        InheritMarshaller instance = (InheritMarshaller)inspector.getInstance(this.ctx);
        Assert.assertSame((Object)this.ctx, (Object)instance.ctx);
        Assert.assertSame((Object)this.ctx, (Object)instance.ctx2);
    }

    @Setup(mode=Instantiations.EACH_TIME)
    public static class InheritMarshaller
    extends EachTimeMarshaller {
        @Inject
        private RenderingContext ctx2;
    }

    @Setup(mode=Instantiations.SINGLETON)
    public static class SingletonMarshaller
    implements Writer<Object> {
        @Inject
        private RenderingContext ctx;

        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public void write(Object entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) throws IOException {
        }
    }

    @Setup(mode=Instantiations.PER_THREAD)
    public static class PerThreadMarshaller
    implements Writer<Object> {
        @Inject
        private RenderingContext ctx;

        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public void write(Object entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) throws IOException {
        }
    }

    @Setup(mode=Instantiations.EACH_TIME)
    public static class EachTimeMarshaller
    implements Writer<Object> {
        @Inject
        protected RenderingContext ctx;

        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public void write(Object entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) throws IOException {
        }
    }

    @Setup(mode=Instantiations.EACH_TIME)
    public static class NoInjectionMarshaller
    implements Writer<Object> {
        private RenderingContext ctx;

        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public void write(Object entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) throws IOException {
        }
    }
}

