/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.registry.reflect;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.core.io.registry.MarshallingException;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.MarshallerInspector;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.io.registry.reflect.Supports;

public class TestInstanciationMode {
    private final RenderingContext ctx = RenderingContext.CtxBuilder.get();

    @Test
    public void canInstanciateWithSetupAndPublicConstructor() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(SimpleMarshaller.class);
        Object instance = inspector.getInstance(this.ctx);
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals(SimpleMarshaller.class, instance.getClass());
    }

    @Test(expected=MarshallingException.class)
    public void cannotInstanciateWithoutSetup() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(MarshallerWithoutSetup.class);
        Assert.assertNull((Object)inspector.getInstance(this.ctx));
    }

    @Test(expected=MarshallingException.class)
    public void cannotInstanciateWithoutPublicConstructor() throws Exception {
        new MarshallerInspector(MarshallerWithoutPublicConstructor.class);
    }

    @Test(expected=MarshallingException.class)
    public void cannotInheritSetup() throws Exception {
        new MarshallerInspector(InheritedSimpleMarshaller.class);
    }

    @Test
    public void defaultSupportsNothing() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(SimpleMarshaller.class);
        Assert.assertTrue((boolean)inspector.getSupports().isEmpty());
    }

    @Test
    public void loadSupports() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(SupportsMarshaller.class);
        Assert.assertEquals((long)2L, (long)inspector.getSupports().size());
        Assert.assertTrue((boolean)inspector.getSupports().contains(MediaType.APPLICATION_JSON_TYPE));
        Assert.assertTrue((boolean)inspector.getSupports().contains(MediaType.APPLICATION_XML_TYPE));
    }

    @Test
    public void inheritSupports() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(InheritedSupportsMarshaller.class);
        Assert.assertEquals((long)2L, (long)inspector.getSupports().size());
        Assert.assertTrue((boolean)inspector.getSupports().contains(MediaType.APPLICATION_JSON_TYPE));
        Assert.assertTrue((boolean)inspector.getSupports().contains(MediaType.APPLICATION_XML_TYPE));
    }

    @Test
    public void overrideSupports() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(OverrideSupportsMarshaller.class);
        Assert.assertEquals((long)1L, (long)inspector.getSupports().size());
        Assert.assertTrue((boolean)inspector.getSupports().contains(MediaType.APPLICATION_JSON_TYPE));
    }

    @Test
    public void eachTimeInstance() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(EachTimeMarshaller.class);
        EachTimeMarshaller instance1 = (EachTimeMarshaller)inspector.getInstance(this.ctx);
        Assert.assertNotNull((Object)instance1);
        EachTimeMarshaller instance2 = (EachTimeMarshaller)inspector.getInstance(this.ctx);
        Assert.assertNotNull((Object)instance2);
        Assert.assertNotSame((Object)instance1, (Object)instance2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void perThreadInstance() throws Exception {
        final MarshallerInspector inspector = new MarshallerInspector(PerThreadMarshaller.class);
        PerThreadMarshaller instance1 = (PerThreadMarshaller)inspector.getInstance(this.ctx);
        Assert.assertNotNull((Object)instance1);
        final PerThreadMarshaller instance2 = (PerThreadMarshaller)inspector.getInstance(this.ctx);
        Assert.assertNotNull((Object)instance2);
        Assert.assertSame((Object)instance1, (Object)instance2);
        Thread subThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    PerThreadMarshaller instance3 = (PerThreadMarshaller)inspector.getInstance(TestInstanciationMode.this.ctx);
                    Assert.assertNotNull((Object)instance3);
                    Assert.assertNotSame((Object)instance2, (Object)instance3);
                    this.notify();
                }
            }
        };
        subThread.start();
        Thread thread = subThread;
        synchronized (thread) {
            subThread.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void singletonInstance() throws Exception {
        final MarshallerInspector inspector = new MarshallerInspector(SingletonMarshaller.class);
        SingletonMarshaller instance1 = (SingletonMarshaller)inspector.getInstance(this.ctx);
        Assert.assertNotNull((Object)instance1);
        final SingletonMarshaller instance2 = (SingletonMarshaller)inspector.getInstance(this.ctx);
        Assert.assertNotNull((Object)instance2);
        Assert.assertSame((Object)instance1, (Object)instance2);
        Thread subThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    SingletonMarshaller instance3 = (SingletonMarshaller)inspector.getInstance(TestInstanciationMode.this.ctx);
                    Assert.assertNotNull((Object)instance3);
                    Assert.assertSame((Object)instance2, (Object)instance3);
                    this.notify();
                }
            }
        };
        subThread.start();
        Thread thread = subThread;
        synchronized (thread) {
            subThread.wait();
        }
    }

    @Setup(mode=Instantiations.SINGLETON)
    public static class SingletonMarshaller
    implements Writer<Object> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public void write(Object entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) throws IOException {
        }
    }

    @Setup(mode=Instantiations.PER_THREAD)
    public static class PerThreadMarshaller
    implements Writer<Object> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public void write(Object entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) throws IOException {
        }
    }

    @Setup(mode=Instantiations.EACH_TIME)
    public static class EachTimeMarshaller
    implements Writer<Object> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public void write(Object entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) throws IOException {
        }
    }

    @Setup(mode=Instantiations.SINGLETON)
    @Supports(value={"application/json"})
    public static class OverrideSupportsMarshaller
    extends SupportsMarshaller {
    }

    @Setup(mode=Instantiations.SINGLETON)
    public static class InheritedSupportsMarshaller
    extends SupportsMarshaller {
    }

    @Setup(mode=Instantiations.SINGLETON)
    @Supports(value={"application/json", "application/xml"})
    public static class SupportsMarshaller
    implements Writer<Object> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public void write(Object entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) throws IOException {
        }
    }

    public static class InheritedSimpleMarshaller
    extends SimpleMarshaller {
    }

    @Setup(mode=Instantiations.SINGLETON)
    public static class SimpleMarshaller
    implements Writer<Object> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public void write(Object entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) throws IOException {
        }
    }

    public static class MarshallerWithoutSetup {
    }

    @Setup(mode=Instantiations.SINGLETON)
    public static class MarshallerWithoutPublicConstructor {
        private MarshallerWithoutPublicConstructor() {
        }
    }
}

