/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.registry.reflect;

import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.core.io.registry.Reader;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.MarshallerInspector;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;

public class TestReaderMarshalledType {
    private Map<String, List<Integer>> listIntegerMapProperty = null;
    private Map<?, ?> mapProperty = null;

    @Test
    public void canGetSupportedJavaType() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(IntegerReader.class);
        Class type = inspector.getMarshalledType();
        Assert.assertNotNull((Object)type);
        Assert.assertEquals(Integer.class, (Object)type);
    }

    @Test
    public void handleInheritedJavaType() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(InheritReader.class);
        Class type = inspector.getMarshalledType();
        Assert.assertNotNull((Object)type);
        Assert.assertEquals(Integer.class, (Object)type);
    }

    @Test
    public void canGetStereotypedMarshaller() throws Exception {
        Type listIntegerMap = TestReaderMarshalledType.class.getDeclaredField("listIntegerMapProperty").getGenericType();
        Type map = TestReaderMarshalledType.class.getDeclaredField("mapProperty").getGenericType();
        MarshallerInspector inspector = new MarshallerInspector(ListIntegerMapReader.class);
        Assert.assertNotNull((Object)inspector.getGenericType());
        Assert.assertEquals((Object)listIntegerMap, (Object)inspector.getGenericType());
        Assert.assertNotEquals((Object)map, (Object)inspector.getGenericType());
    }

    @Setup(mode=Instantiations.SINGLETON)
    public static class ListIntegerMapReader
    implements Reader<Map<String, List<Integer>>> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public Map<String, List<Integer>> read(Class<?> clazz, Type genericType, MediaType mediatype, InputStream in) {
            return null;
        }
    }

    @Setup(mode=Instantiations.SINGLETON, priority=2000)
    public static class InheritReader
    extends IntegerReader {
    }

    @Setup(mode=Instantiations.SINGLETON)
    public static class IntegerReader
    implements Reader<Integer> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public Integer read(Class<?> clazz, Type genericType, MediaType mediatype, InputStream in) {
            return null;
        }
    }
}

