/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.registry.reflect;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.MarshallerInspector;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
public class TestServiceInjection {
    private final RenderingContext ctx = RenderingContext.CtxBuilder.get();

    @Test
    public void noInjectionIfNoAnnotation() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(NoInjectionMarshaller.class);
        NoInjectionMarshaller instance = (NoInjectionMarshaller)inspector.getInstance(this.ctx);
        Assert.assertNull((Object)instance.service);
    }

    @Test
    public void injectService() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(SimpleServiceMarshaller.class);
        SimpleServiceMarshaller instance = (SimpleServiceMarshaller)inspector.getInstance(this.ctx);
        Assert.assertNotNull((Object)instance.service);
    }

    @Test
    public void inheritInjection() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(InheritMarshaller.class);
        InheritMarshaller instance = (InheritMarshaller)inspector.getInstance(this.ctx);
        Assert.assertNotNull((Object)instance.service);
        Assert.assertNotNull((Object)instance.service2);
    }

    @Setup(mode=Instantiations.EACH_TIME)
    public static class InheritMarshaller
    extends SimpleServiceMarshaller {
        @Inject
        private SchemaManager service2;
    }

    @Setup(mode=Instantiations.EACH_TIME)
    public static class NoInjectionMarshaller
    implements Writer<Object> {
        private SchemaManager service;

        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public void write(Object entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) throws IOException {
        }
    }

    @Setup(mode=Instantiations.EACH_TIME)
    public static class SimpleServiceMarshaller
    implements Writer<Object> {
        @Inject
        protected SchemaManager service;

        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public void write(Object entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) throws IOException {
        }
    }
}

