/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.registry.reflect;

import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.MarshallerInspector;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;

public class TestWriterMarshalledType {
    private Map<String, List<Integer>> listIntegerMapProperty = null;
    private Map<?, ?> mapProperty = null;

    @Test
    public void canGetSupportedJavaType() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(IntegerWriter.class);
        Class type = inspector.getMarshalledType();
        Assert.assertNotNull((Object)type);
        Assert.assertEquals(Integer.class, (Object)type);
    }

    @Test
    public void handleInheritedJavaType() throws Exception {
        MarshallerInspector inspector = new MarshallerInspector(InheritWriter.class);
        Class type = inspector.getMarshalledType();
        Assert.assertNotNull((Object)type);
        Assert.assertEquals(Integer.class, (Object)type);
    }

    @Test
    public void canGetStereotypedMarshaller() throws Exception {
        Type listIntegerMap = TestWriterMarshalledType.class.getDeclaredField("listIntegerMapProperty").getGenericType();
        Type map = TestWriterMarshalledType.class.getDeclaredField("mapProperty").getGenericType();
        MarshallerInspector inspector = new MarshallerInspector(ListIntegerMapWriter.class);
        Assert.assertNotNull((Object)inspector.getGenericType());
        Assert.assertEquals((Object)listIntegerMap, (Object)inspector.getGenericType());
        Assert.assertNotEquals((Object)map, (Object)inspector.getGenericType());
    }

    @Setup(mode=Instantiations.SINGLETON)
    public static class ListIntegerMapWriter
    implements Writer<Map<String, List<Integer>>> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public void write(Map<String, List<Integer>> entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) {
        }
    }

    @Setup(mode=Instantiations.SINGLETON, priority=2000)
    public static class InheritWriter
    extends IntegerWriter {
    }

    @Setup(mode=Instantiations.SINGLETON)
    public static class IntegerWriter
    implements Writer<Integer> {
        public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
            return true;
        }

        public void write(Integer entity, Class<?> clazz, Type genericType, MediaType mediatype, OutputStream out) {
        }
    }
}

