/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.transform;

import java.io.File;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentTransformer;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.ExportExtension;
import org.nuxeo.ecm.core.io.impl.TransactionBatchingDocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.extensions.LockExporterExtension;
import org.nuxeo.ecm.core.io.impl.extensions.VersionInfoExportExtension;
import org.nuxeo.ecm.core.io.impl.plugins.ExtensibleDocumentTreeReader;
import org.nuxeo.ecm.core.io.impl.plugins.XMLDirectoryWriter;
import org.nuxeo.ecm.core.io.impl.transformers.DoctypeToFacetTranslator;
import org.nuxeo.ecm.core.io.impl.transformers.FacetRemover;
import org.nuxeo.ecm.core.io.impl.transformers.FieldMapper;
import org.nuxeo.ecm.core.io.impl.transformers.SchemaRemover;
import org.nuxeo.ecm.core.io.impl.transformers.SchemaRenamer;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class BaseExport {
    @Inject
    protected CoreSession session;
    String uuid;
    protected boolean skipBlobs = true;
    public static final String IODIR = "NX-Export-Import";

    protected DocumentModel createSomethingToExport(CoreSession session) throws Exception {
        DocumentModel rootDocument = session.getRootDocument();
        DocumentModel workspace = session.createDocumentModel(rootDocument.getPathAsString(), "ws1", "Workspace");
        workspace.setProperty("dublincore", "title", (Object)"test WS");
        workspace = session.createDocument(workspace);
        DocumentModel invoiceDoc = session.createDocumentModel(workspace.getPathAsString(), "invoice", "Invoice");
        invoiceDoc.setProperty("dublincore", "title", (Object)"MyDoc");
        invoiceDoc.setProperty("invoice", "InvoiceNumber", (Object)"0001");
        invoiceDoc.setPropertyValue("inv:InvoiceAmount", (Serializable)((Object)"$10,000"));
        invoiceDoc.setPropertyValue("dep:fieldA", (Serializable)new String[]{"A", "B", "C"});
        invoiceDoc.setPropertyValue("dep:fieldB", (Serializable)((Object)"XYZ"));
        invoiceDoc.setPropertyValue("dep:fieldC", (Serializable)((Object)"foo"));
        invoiceDoc.setPropertyValue("dep:fieldD", (Serializable)((Object)"bar"));
        StringBlob blob = new StringBlob("SomeDummyContent");
        blob.setFilename("dummyBlob.txt");
        invoiceDoc.setProperty("file", "content", (Object)blob);
        invoiceDoc = session.createDocument(invoiceDoc);
        invoiceDoc.addFacet("HiddenInNavigation");
        invoiceDoc = session.saveDocument(invoiceDoc);
        DocumentModel folderDoc = session.createDocumentModel(workspace.getPathAsString(), "folder", "Folder");
        folderDoc.setProperty("dublincore", "title", (Object)"MyFolder");
        folderDoc = session.createDocument(folderDoc);
        DocumentModel fileDoc2 = session.createDocumentModel(folderDoc.getPathAsString(), "file", "File");
        fileDoc2.setProperty("dublincore", "title", (Object)"MyDoc");
        StringBlob blob2 = new StringBlob("SomeDummyContent2");
        blob.setFilename("dummyBlob2.txt");
        fileDoc2.setProperty("file", "content", (Object)blob2);
        fileDoc2 = session.createDocument(fileDoc2);
        fileDoc2.putContextData("VersioningOption", (Serializable)VersioningOption.MAJOR);
        fileDoc2.setPropertyValue("dc:description", (Serializable)((Object)"Youhou"));
        fileDoc2 = session.saveDocument(fileDoc2);
        fileDoc2.putContextData("VersioningOption", (Serializable)VersioningOption.MINOR);
        fileDoc2.setPropertyValue("dc:description", (Serializable)((Object)"Youhou2"));
        fileDoc2 = session.saveDocument(fileDoc2);
        fileDoc2.followTransition("approve");
        Assert.assertEquals((Object)"approved", (Object)fileDoc2.getCurrentLifeCycleState());
        this.uuid = fileDoc2.getId();
        invoiceDoc.setLock();
        session.save();
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        Thread.sleep(200L);
        EventService es = (EventService)Framework.getLocalService(EventService.class);
        es.waitForAsyncCompletion();
        return workspace;
    }

    protected File getExportDirectory() {
        return this.getExportDirectory(true);
    }

    protected File getExportDirectory(boolean delete) {
        String tempDir = System.getProperty("java.io.tmpdir");
        File dir = new File(tempDir + "/" + IODIR);
        if (dir.exists()) {
            if (delete) {
                FileUtils.deleteQuietly((File)dir);
            } else {
                return dir;
            }
        }
        dir.mkdirs();
        return dir;
    }

    protected void runExport(DocumentModel root, File destination, boolean skipBlobs) throws Exception {
        ExtensibleDocumentTreeReader reader = new ExtensibleDocumentTreeReader(root.getCoreSession(), root);
        XMLDirectoryWriter writer = new XMLDirectoryWriter(destination);
        writer.setSkipBlobs(skipBlobs);
        reader.registerExtension((ExportExtension)new VersionInfoExportExtension());
        reader.registerExtension((ExportExtension)new LockExporterExtension());
        TransactionBatchingDocumentPipeImpl pipe = new TransactionBatchingDocumentPipeImpl(10);
        pipe.setReader((DocumentReader)reader);
        pipe.setWriter((DocumentWriter)writer);
        pipe.addTransformer((DocumentTransformer)new DoctypeToFacetTranslator("Invoice", "File", "Invoice"));
        pipe.addTransformer((DocumentTransformer)new FacetRemover(null, "IOnlyExistsInV1"));
        pipe.addTransformer((DocumentTransformer)new FacetRemover(null, "Immutable"));
        pipe.addTransformer((DocumentTransformer)new FieldMapper("deprecated", "dep:fieldA", "invoice", "inv:A"));
        pipe.addTransformer((DocumentTransformer)new FieldMapper("deprecated", "dep:fieldB", "invoice", "inv:B"));
        pipe.addTransformer((DocumentTransformer)new FieldMapper("deprecated", "dep:fieldC", "new", "nw:Y"));
        pipe.addTransformer((DocumentTransformer)new SchemaRemover(null, "deprecated"));
        pipe.addTransformer((DocumentTransformer)new SchemaRenamer("invoice", "invoiceNew", "iv"));
        pipe.run();
    }

    protected void dump(StringBuffer sb, File root) {
        for (File f : root.listFiles()) {
            sb.append(f.getAbsolutePath());
            sb.append("\n");
            if (!f.isDirectory()) continue;
            this.dump(sb, f);
        }
    }

    protected void dump(StringBuffer sb, DocumentModelList alldocs) {
        for (DocumentModel doc : alldocs) {
            sb.append(doc.getId());
            sb.append(" - ");
            sb.append(doc.getPathAsString());
            sb.append(" - ");
            sb.append(doc.getType());
            sb.append(" - ");
            sb.append(doc.getTitle());
            sb.append(" - ");
            sb.append(doc.isVersion());
            sb.append(" - ");
            sb.append(doc.getVersionLabel());
            sb.append("\n");
        }
    }
}

