/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.transform;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.ImportExtension;
import org.nuxeo.ecm.core.io.impl.TransactionBatchingDocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.extensions.DocumentLockImporter;
import org.nuxeo.ecm.core.io.impl.plugins.ExtensibleDocumentWriter;
import org.nuxeo.ecm.core.io.impl.plugins.XMLDirectoryReader;
import org.nuxeo.ecm.core.io.transform.BaseExport;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.TransactionalFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={TransactionalFeature.class, CoreFeature.class})
@LocalDeploy(value={"org.nuxeo.ecm.core.io.test:OSGI-INF/export-docTypes.xml", "org.nuxeo.ecm.core.io.test:OSGI-INF/import-docTypes.xml", "org.nuxeo.ecm.core.io.test:OSGI-INF/other-repo.xml"})
public class ExportAndTransformAndInportTest
extends BaseExport {
    public void runImport(DocumentModel root, File source) throws IOException {
        XMLDirectoryReader reader = new XMLDirectoryReader(source);
        ExtensibleDocumentWriter writer = new ExtensibleDocumentWriter(root.getCoreSession(), root.getPathAsString());
        writer.registerExtension((ImportExtension)new DocumentLockImporter());
        TransactionBatchingDocumentPipeImpl pipe = new TransactionBatchingDocumentPipeImpl(10);
        pipe.setReader((DocumentReader)reader);
        pipe.setWriter((DocumentWriter)writer);
        pipe.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportWithTransformThenImport() throws Exception {
        Principal principal = this.session.getPrincipal();
        CoreSession importSession = null;
        DocumentModel root = this.createSomethingToExport(this.session);
        File out = this.getExportDirectory();
        try {
            this.runExport(root, out, this.skipBlobs);
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
            importSession = CoreInstance.openCoreSession((String)"import", (Principal)principal);
            this.runImport(importSession.getRootDocument(), out);
            importSession.save();
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
            Thread.sleep(2000L);
            DocumentModelList alldocs = importSession.query("select * from Document order by ecm:path");
            StringBuffer sb = new StringBuffer();
            this.dump(sb, alldocs);
            String listing = sb.toString();
            Assert.assertTrue((boolean)listing.contains("/ws1/folder/file"));
            Assert.assertTrue((boolean)importSession.exists(root.getRef()));
            PathRef ref = new PathRef("/ws1/folder/file");
            DocumentModel doc = this.session.getDocument((DocumentRef)ref);
            Assert.assertNotNull((Object)doc);
            Assert.assertEquals((Object)"approved", (Object)doc.getCurrentLifeCycleState());
            List versions = importSession.getVersions((DocumentRef)ref);
            Assert.assertEquals((long)2L, (long)versions.size());
            DocumentModel invoice = importSession.getDocument((DocumentRef)new PathRef("/ws1/invoice"));
            Assert.assertEquals((Object)"File", (Object)invoice.getType());
            Assert.assertTrue((boolean)invoice.hasFacet("Invoice"));
            Assert.assertEquals((Object)"$10,000", (Object)invoice.getPropertyValue("iv:InvoiceAmount"));
            Assert.assertEquals((Object)"XYZ", (Object)invoice.getPropertyValue("iv:B"));
            String[] lst = (String[])invoice.getPropertyValue("iv:A");
            Assert.assertEquals((Object)"A", (Object)lst[0]);
            Assert.assertEquals((Object)"B", (Object)lst[1]);
            Assert.assertEquals((Object)"foo", (Object)invoice.getPropertyValue("nw:Y"));
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
            Assert.assertTrue((boolean)invoice.isLocked());
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly((File)out);
            if (importSession != null) {
                CoreInstance.closeCoreSession(importSession);
            }
            throw throwable;
        }
        FileUtils.deleteQuietly((File)out);
        if (importSession != null) {
            CoreInstance.closeCoreSession((CoreSession)importSession);
        }
    }
}

