/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.transform;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.io.transform.BaseExport;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.TransactionalFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={TransactionalFeature.class, CoreFeature.class})
@LocalDeploy(value={"org.nuxeo.ecm.core.io.test:OSGI-INF/export-docTypes.xml"})
public class ExportAndTransformTest
extends BaseExport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportWithTransform() throws Exception {
        DocumentModel root = this.createSomethingToExport(this.session);
        DocumentModelList versions = this.session.query("select * from Document where ecm:isCheckedInVersion = 1");
        Assert.assertEquals((long)2L, (long)versions.size());
        File out = this.getExportDirectory();
        try {
            this.runExport(root, out, this.skipBlobs);
            StringBuffer sb = new StringBuffer();
            this.dump(sb, out);
            String listing = sb.toString();
            Assert.assertTrue((boolean)listing.contains("ws1/folder/file/document.xml"));
            Assert.assertTrue((boolean)listing.contains("ws1/folder/file/__versions__/1.0/document.xml"));
            Assert.assertTrue((boolean)listing.contains("ws1/invoice/document.xml"));
            String xml = FileUtils.readFileToString((File)new File(out, "ws1/invoice/document.xml"));
            Assert.assertTrue((boolean)xml.contains("<type>File</type>"));
            Assert.assertTrue((boolean)xml.contains("<facet>Invoice</facet>"));
            Assert.assertTrue((boolean)xml.contains("name=\"invoiceNew\">"));
            Assert.assertTrue((boolean)xml.contains("<iv:A>"));
            Assert.assertTrue((boolean)xml.contains("<iv:B>XYZ"));
            Assert.assertFalse((boolean)xml.contains("deprecated"));
            Assert.assertTrue((boolean)xml.contains("<schema name=\"new\""));
            Assert.assertTrue((boolean)xml.contains("<Y>foo</Y>"));
            Assert.assertTrue((boolean)xml.contains("<lockInfo"));
            Assert.assertTrue((boolean)xml.contains("<owner>Administrator</owner>"));
        }
        finally {
            FileUtils.deleteQuietly((File)out);
        }
    }
}

