/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.format;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tngtech.jgiven.annotation.AnnotationFormat;
import com.tngtech.jgiven.annotation.Format;
import com.tngtech.jgiven.annotation.Table;
import com.tngtech.jgiven.config.FormatterConfiguration;
import com.tngtech.jgiven.exception.AmbiguousFormattingException;
import com.tngtech.jgiven.exception.JGivenWrongUsageException;
import com.tngtech.jgiven.format.DefaultFormatter;
import com.tngtech.jgiven.format.Formatter;
import com.tngtech.jgiven.format.ObjectFormatter;
import com.tngtech.jgiven.format.table.TableFormatter;
import com.tngtech.jgiven.format.table.TableFormatterFactory;
import com.tngtech.jgiven.impl.util.AnnotationUtil;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import com.tngtech.jgiven.report.model.StepFormatter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ParameterFormattingUtil {
    private static final StepFormatter.Formatting<?, ?> DEFAULT_FORMATTING = new StepFormatter.ArgumentFormatting(new DefaultFormatter(), new String[0]);
    private final FormatterConfiguration configuration;

    public ParameterFormattingUtil(FormatterConfiguration configuration) {
        this.configuration = configuration;
    }

    public <T> ObjectFormatter<?> getFormatting(Class<T> parameterType, String parameterName, Annotation[] annotations) {
        StepFormatter.Formatting formatting = this.getFormatting(annotations, Sets.newHashSet(), null, parameterName);
        if (formatting == null) {
            Formatter<?> formatter = this.configuration.getFormatter(parameterType);
            formatting = formatter != null ? new StepFormatter.TypeBasedFormatting(formatter, annotations) : DEFAULT_FORMATTING;
        }
        return formatting;
    }

    private StepFormatter.Formatting<?, ?> getFormatting(Annotation[] annotations, Set<Class<?>> visitedTypes, Annotation originalAnnotation, String parameterName) {
        ArrayList foundFormatting = Lists.newArrayList();
        Table tableAnnotation = null;
        for (Annotation annotation : annotations) {
            try {
                Annotation arg;
                if (annotation instanceof Format) {
                    arg = (Format)annotation;
                    foundFormatting.add(new StepFormatter.ArgumentFormatting(ReflectionUtil.newInstance(arg.value()), arg.args()));
                    continue;
                }
                if (annotation instanceof Table) {
                    tableAnnotation = (Table)annotation;
                    continue;
                }
                if (annotation instanceof AnnotationFormat) {
                    arg = (AnnotationFormat)annotation;
                    foundFormatting.add(new StepFormatter.ArgumentFormatting(new StepFormatter.AnnotationBasedFormatter(arg.value().newInstance(), originalAnnotation), new String[0]));
                    continue;
                }
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (visitedTypes.contains(annotationType)) continue;
                visitedTypes.add(annotationType);
                StepFormatter.Formatting<?, ?> formatting = this.getFormatting(annotationType.getAnnotations(), visitedTypes, annotation, parameterName);
                if (formatting == null) continue;
                foundFormatting.add(formatting);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        if (foundFormatting.size() > 1) {
            throw new AmbiguousFormattingException("Found more than one formatting annotation at parameter " + parameterName);
        }
        if (tableAnnotation != null) {
            DefaultFormatter objectFormatter = foundFormatting.isEmpty() ? DefaultFormatter.INSTANCE : (ObjectFormatter)foundFormatting.get(0);
            return this.getTableFormatting(annotations, parameterName, tableAnnotation, objectFormatter);
        }
        if (foundFormatting.isEmpty()) {
            return null;
        }
        return (StepFormatter.Formatting)foundFormatting.get(0);
    }

    private StepFormatter.Formatting<?, ?> getTableFormatting(Annotation[] annotations, String parameterName, Table annotation, ObjectFormatter<?> objectFormatter) {
        Table tableAnnotation = annotation;
        TableFormatterFactory factory = this.createTableFormatterFactory(parameterName, tableAnnotation);
        TableFormatter tableFormatter = factory.create(this.configuration, objectFormatter);
        return new StepFormatter.TableFormatting<TableFormatter>(tableFormatter, tableAnnotation, parameterName, annotations);
    }

    private TableFormatterFactory createTableFormatterFactory(String parameterName, Table tableAnnotation) {
        Class<? extends TableFormatterFactory> formatterFactoryClass = tableAnnotation.formatter();
        try {
            return ReflectionUtil.newInstance(formatterFactoryClass);
        }
        catch (Exception e) {
            throw new JGivenWrongUsageException("Could not create an instance of " + formatterFactoryClass.getName() + " which was specified at the @Table annotation for parameter '" + parameterName + "'. Most likely this was due to a missing default constructor", TableFormatterFactory.class, e);
        }
    }

    public List<String> toStringList(List<ObjectFormatter<?>> formatter, List<?> arguments) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < arguments.size(); ++i) {
            ObjectFormatter<Object> formatting = DEFAULT_FORMATTING;
            if (i < formatter.size() && formatter.get(i) != null) {
                formatting = formatter.get(i);
            }
            result.add(this.formatUsingFormatterOrDefault(formatting, arguments.get(i)));
        }
        return result;
    }

    private <T> String formatUsingFormatterOrDefault(ObjectFormatter<T> formatting, Object o) {
        return formatting.format(o);
    }

    public List<ObjectFormatter<?>> getFormatter(Class<?>[] parameterTypes, List<String> parameterNames, Annotation[][] parameterAnnotations) {
        ArrayList res = Lists.newArrayList();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            if (AnnotationUtil.isHidden(annotations)) continue;
            String parameterName = i < parameterNames.size() ? parameterNames.get(i) : "param" + i;
            res.add(this.getFormatting(parameterTypes[i], parameterName, annotations));
        }
        return res;
    }
}

