/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.intercept;

import com.tngtech.jgiven.annotation.DoNotIntercept;
import com.tngtech.jgiven.annotation.NestedSteps;
import com.tngtech.jgiven.annotation.NotImplementedYet;
import com.tngtech.jgiven.annotation.Pending;
import com.tngtech.jgiven.impl.intercept.StepMethodHandler;
import com.tngtech.jgiven.report.model.InvocationMode;
import java.lang.reflect.Method;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepMethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(StepMethodInterceptor.class);
    private StepMethodHandler scenarioMethodHandler;
    private AtomicInteger stackDepth;
    private int maxStepDepth = 1;
    private final Stack<Method> methodCallStack = new Stack();
    private boolean methodHandlingEnabled;
    private boolean methodExecutionEnabled = true;

    public StepMethodInterceptor(StepMethodHandler scenarioMethodHandler, AtomicInteger stackDepth) {
        this.scenarioMethodHandler = scenarioMethodHandler;
        this.stackDepth = stackDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object doIntercept(Object receiver, Method method, Object[] parameters, Invoker invoker) throws Throwable {
        int currentStackDepth = this.stackDepth.incrementAndGet();
        try {
            if (!this.shouldInterceptMethod(method)) {
                Object object = invoker.proceed();
                return object;
            }
            Object object = this.intercept(receiver, method, parameters, invoker, currentStackDepth);
            return object;
        }
        finally {
            this.stackDepth.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object intercept(Object receiver, Method method, Object[] parameters, Invoker invoker, int currentStackDepth) throws Throwable {
        long started = System.nanoTime();
        InvocationMode mode = this.getInvocationMode(receiver, method);
        if (mode == InvocationMode.DO_NOT_INTERCEPT) {
            return invoker.proceed();
        }
        boolean hasNestedSteps = method.isAnnotationPresent(NestedSteps.class);
        if (this.methodHandlingEnabled) {
            this.scenarioMethodHandler.handleMethod(receiver, method, parameters, mode, hasNestedSteps);
        }
        if (mode == InvocationMode.SKIPPED || mode == InvocationMode.PENDING) {
            return this.returnReceiverOrNull(receiver, method);
        }
        if (hasNestedSteps) {
            ++this.maxStepDepth;
        }
        try {
            Object object = invoker.proceed();
            return object;
        }
        catch (Exception e) {
            Object object = this.handleThrowable(receiver, method, e, System.nanoTime() - started);
            return object;
        }
        catch (AssertionError e) {
            Object object = this.handleThrowable(receiver, method, (Throwable)((Object)e), System.nanoTime() - started);
            return object;
        }
        finally {
            if (hasNestedSteps) {
                --this.maxStepDepth;
            }
            if (this.methodHandlingEnabled) {
                this.scenarioMethodHandler.handleMethodFinished(System.nanoTime() - started, hasNestedSteps);
            }
        }
    }

    private boolean shouldInterceptMethod(Method method) {
        if (method.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        return this.stackDepth.get() <= this.maxStepDepth;
    }

    protected Object handleThrowable(Object receiver, Method method, Throwable t, long durationInNanos) throws Throwable {
        if (this.methodHandlingEnabled) {
            this.scenarioMethodHandler.handleThrowable(t);
            return this.returnReceiverOrNull(receiver, method);
        }
        throw t;
    }

    protected Object returnReceiverOrNull(Object receiver, Method method) {
        if (!method.getReturnType().isAssignableFrom(receiver.getClass())) {
            if (method.getReturnType() != Void.class) {
                log.warn("The step method " + method.getName() + " of class " + method.getDeclaringClass().getSimpleName() + " does not follow the fluent interface convention of returning " + "the receiver object. Please change the return type to the SELF type parameter.");
            }
            return null;
        }
        return receiver;
    }

    protected InvocationMode getInvocationMode(Object receiver, Method method) {
        if (method.getDeclaringClass() == Object.class || method.isAnnotationPresent(DoNotIntercept.class)) {
            return InvocationMode.DO_NOT_INTERCEPT;
        }
        if (!this.methodExecutionEnabled) {
            return InvocationMode.SKIPPED;
        }
        if (method.isAnnotationPresent(NotImplementedYet.class) || receiver.getClass().isAnnotationPresent(NotImplementedYet.class) || method.isAnnotationPresent(Pending.class) || receiver.getClass().isAnnotationPresent(Pending.class)) {
            return InvocationMode.PENDING;
        }
        return InvocationMode.NORMAL;
    }

    public void enableMethodHandling(boolean b) {
        this.methodHandlingEnabled = b;
    }

    public void disableMethodExecution() {
        this.methodExecutionEnabled = false;
    }

    public boolean enableMethodExecution(boolean b) {
        boolean previousMethodExecution = this.methodExecutionEnabled;
        this.methodExecutionEnabled = b;
        return previousMethodExecution;
    }

    public StepMethodHandler getScenarioMethodHandler() {
        return this.scenarioMethodHandler;
    }

    public AtomicInteger getStackDepth() {
        return this.stackDepth;
    }

    public void setScenarioMethodHandler(StepMethodHandler scenarioMethodHandler) {
        this.scenarioMethodHandler = scenarioMethodHandler;
    }

    public void setStackDepth(AtomicInteger stackDepth) {
        this.stackDepth = stackDepth;
    }

    public static interface Invoker {
        public Object proceed() throws Throwable;
    }
}

