/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.analysis;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.Word;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class CaseDifferenceAnalyzer {
    public void analyze(ScenarioModel scenarioModel) {
        if (scenarioModel.getScenarioCases().size() < 2) {
            return;
        }
        CollectPhase collectPhase = new CollectPhase(scenarioModel);
        scenarioModel.accept(collectPhase);
        List<Sequence> commonSequences = CaseDifferenceAnalyzer.findCommonSequence(collectPhase.allWords);
        for (Sequence seq : commonSequences) {
            seq.setDifferenceToWords();
        }
    }

    private static List<Sequence> findCommonSequence(List<List<Word>> input) {
        Searcher searcher;
        int[] nextMatching;
        ArrayList<Sequence> result = new ArrayList<Sequence>();
        for (List<Word> s : input) {
            Sequence seq = new Sequence();
            seq.input = s;
            result.add(seq);
        }
        int[] startIndices = new int[input.size()];
        while (!CaseDifferenceAnalyzer.someAtEnd(result) && (nextMatching = (searcher = new Searcher(input, startIndices)).findNextMatching()) != null) {
            for (int i = 0; i < result.size(); ++i) {
                ((Sequence)result.get((int)i)).elements.add(nextMatching[i]);
            }
            startIndices = CaseDifferenceAnalyzer.incAllByOne(nextMatching);
        }
        return result;
    }

    private static int[] incAllByOne(int[] matching) {
        int[] result = new int[matching.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = matching[i] + 1;
        }
        return result;
    }

    private static boolean someAtEnd(List<Sequence> result) {
        for (Sequence s : result) {
            if (!s.isAtEnd()) continue;
            return true;
        }
        return false;
    }

    static class CollectPhase
    extends ReportModelVisitor {
        List<CaseArguments> argumentMatrix = Lists.newArrayList();
        List<ArgumentHolder> argumentsOfCurrentCase;
        List<List<Word>> allWords = Lists.newArrayList();
        List<Word> allWordsOfCurrentCase;
        ScenarioCaseModel currentCase;
        final ScenarioModel scenarioModel;
        boolean noDataTablePossible;

        public CollectPhase(ScenarioModel model) {
            this.scenarioModel = model;
        }

        @Override
        public void visit(ScenarioCaseModel scenarioCase) {
            this.currentCase = scenarioCase;
            this.argumentsOfCurrentCase = Lists.newArrayList();
            this.argumentMatrix.add(new CaseArguments(this.argumentsOfCurrentCase));
            this.allWordsOfCurrentCase = Lists.newArrayList();
            this.allWords.add(this.allWordsOfCurrentCase);
        }

        @Override
        public void visit(StepModel stepModel) {
            if (stepModel.getAttachment() != null && stepModel.getAttachment().isShowDirectly()) {
                this.noDataTablePossible = true;
            }
            for (Word word : stepModel.getWords()) {
                if (word.isArg() && !word.isDataTable()) {
                    ArgumentHolder holder = new ArgumentHolder();
                    holder.word = word;
                    holder.params = this.getMatchingParameters(word);
                    this.argumentsOfCurrentCase.add(holder);
                }
                this.allWordsOfCurrentCase.add(word);
            }
        }

        private Set<ParameterMatch> getMatchingParameters(Word word) {
            LinkedHashSet matchingParameters = Sets.newLinkedHashSet();
            for (int i = 0; i < this.currentCase.getExplicitArguments().size(); ++i) {
                String argumentValue = this.currentCase.getExplicitArguments().get(i);
                if (!Objects.equal((Object)word.getValue(), (Object)argumentValue) || i >= this.scenarioModel.getExplicitParameters().size()) continue;
                ParameterMatch match = new ParameterMatch();
                match.index = i;
                match.parameter = this.scenarioModel.getExplicitParameters().get(i);
                if (!Objects.equal((Object)word.getFormattedValue(), (Object)argumentValue)) continue;
                matchingParameters.add(match);
            }
            return matchingParameters;
        }
    }

    static class ArgumentHolder {
        Word word;
        Set<ParameterMatch> params;

        ArgumentHolder() {
        }
    }

    static class ParameterMatch {
        String parameter;
        int index;

        ParameterMatch() {
        }
    }

    private static final class CaseArguments {
        final List<ArgumentHolder> arguments;

        private CaseArguments(List<ArgumentHolder> arguments) {
            this.arguments = arguments;
        }

        public ArgumentHolder get(int i) {
            return this.arguments.get(i);
        }
    }

    static class Searcher {
        List<List<Word>> input;
        int[] currentIndices;
        int currentRow;
        Word value;
        int[] startIndices;

        Searcher(List<List<Word>> input, int[] startIndices) {
            this.input = input;
            this.startIndices = startIndices;
            this.currentIndices = Arrays.copyOf(startIndices, startIndices.length);
            this.initSearch();
        }

        private void initSearch() {
            this.value = this.input.get(0).get(this.currentIndices[0]);
            this.currentRow = 1;
        }

        public int[] findNextMatching() {
            return this.findNext();
        }

        private int[] findNext() {
            while (this.currentRow < this.input.size()) {
                if (this.currentRowAtEnd()) {
                    if (this.backTrack()) continue;
                    return null;
                }
                if (this.getCurrentValue().equals(this.value)) {
                    ++this.currentRow;
                    continue;
                }
                this.currentIndices[this.currentRow] = this.getCurrentIndex() + 1;
            }
            return this.currentIndices;
        }

        private boolean backTrack() {
            if (this.currentRow == 0) {
                this.currentIndices[this.currentRow] = this.getCurrentIndex() + 1;
                if (this.currentRowAtEnd()) {
                    return false;
                }
                this.value = this.getCurrentValue();
                ++this.currentRow;
                return true;
            }
            this.currentIndices[this.currentRow] = this.startIndices[this.currentRow];
            --this.currentRow;
            return this.backTrack();
        }

        private Word getCurrentValue() {
            return this.input.get(this.currentRow).get(this.getCurrentIndex());
        }

        private int getCurrentIndex() {
            return this.currentIndices[this.currentRow];
        }

        private boolean currentRowAtEnd() {
            return this.getCurrentIndex() == this.input.get(this.currentRow).size();
        }
    }

    static class Sequence {
        List<Word> input;
        List<Integer> elements = new ArrayList<Integer>();

        Sequence() {
        }

        int getLastIndex() {
            return this.elements.get(this.elements.size() - 1);
        }

        boolean isAtEnd() {
            if (this.elements.isEmpty()) {
                return this.input.isEmpty();
            }
            return this.getLastIndex() == this.input.size() - 1;
        }

        public void setDifferenceToWords() {
            for (Word word : this.input) {
                word.setIsDifferent(true);
            }
            for (Integer i : this.elements) {
                this.input.get(i).setIsDifferent(false);
            }
        }
    }
}

