/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.text;

import com.tngtech.jgiven.confg.ConfigValue;
import com.tngtech.jgiven.impl.Config;
import com.tngtech.jgiven.impl.util.PrintWriterUtil;
import com.tngtech.jgiven.impl.util.ResourceUtil;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.text.DataTablePlainTextScenarioWriter;
import com.tngtech.jgiven.report.text.PlainTextScenarioWriter;
import com.tngtech.jgiven.report.text.PlainTextWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;

public class PlainTextReporter
extends PlainTextWriter {
    private static final ConfigValue COLOR_CONFIG = Config.config().textColorEnabled();

    public static String toString(ScenarioModel scenarioModel) throws UnsupportedEncodingException {
        ReportModel model = new ReportModel();
        model.addScenarioModel(scenarioModel);
        return PlainTextReporter.toString(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(ReportModel model) throws UnsupportedEncodingException {
        String string;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        PlainTextReporter textWriter = new PlainTextReporter(printWriter, ConfigValue.FALSE);
        try {
            textWriter.write(model);
            string = stringWriter.toString();
        }
        catch (Throwable throwable) {
            ResourceUtil.close(printWriter);
            throw throwable;
        }
        ResourceUtil.close(printWriter);
        return string;
    }

    public PlainTextReporter() {
        this(COLOR_CONFIG);
    }

    public PlainTextReporter(ConfigValue colorConfig) {
        this(PrintWriterUtil.getPrintWriter(System.out, colorConfig), colorConfig);
    }

    public PlainTextReporter(PrintWriter printWriter, ConfigValue colorConfig) {
        super(printWriter, colorConfig != ConfigValue.FALSE);
    }

    public PlainTextReporter write(ReportModel model) {
        model.accept(this);
        return this;
    }

    @Override
    public void visit(ReportModel multiScenarioModel) {
        this.writer.println();
        String title = this.bold("Test Class: ");
        title = title + multiScenarioModel.getClassName();
        this.writer.println(title);
    }

    @Override
    public void visit(ScenarioModel scenarioModel) {
        if (scenarioModel.isCasesAsTable()) {
            scenarioModel.accept(new DataTablePlainTextScenarioWriter(this.writer, this.withColor));
        } else {
            scenarioModel.accept(new PlainTextScenarioWriter(this.writer, this.withColor));
        }
    }

    public void flush() {
        this.writer.flush();
    }
}

