/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.util;

import java.util.Formatter;
import java.util.Locale;

public class DurationFormatter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(long durationInNanos) {
        Formatter usFormatter = new Formatter(Locale.US);
        Duration duration = DurationFormatter.getHumanReadableDuration(durationInNanos);
        try {
            String string = usFormatter.format("%.2f ", duration.value) + duration.unit;
            return string;
        }
        finally {
            usFormatter.close();
        }
    }

    private static Duration getHumanReadableDuration(double durationInNanos) {
        Duration result = new Duration();
        result.value = durationInNanos / 1000000.0;
        result.unit = "ms";
        if (result.value < 1000.0) {
            return result;
        }
        result.value /= 1000.0;
        result.unit = "s";
        if (result.value < 60.0) {
            return result;
        }
        result.value /= 60.0;
        result.unit = "min";
        return result;
    }

    static class Duration {
        String unit;
        double value;

        Duration() {
        }
    }
}

