/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone.commands;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.common.Environment;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.standalone.PackageTestCase;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.util.PackageBuilder;
import org.nuxeo.connect.update.xml.XmlWriter;
import org.nuxeo.runtime.test.runner.ConditionalIgnoreRule;

public abstract class AbstractCommandTest
extends PackageTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Environment.getDefault().getConfig().mkdirs();
        new File(Environment.getDefault().getHome(), "bundles").mkdirs();
        new File(Environment.getDefault().getHome(), "lib").mkdirs();
    }

    protected abstract void updatePackage(PackageBuilder var1) throws Exception;

    protected abstract void writeCommand(XmlWriter var1);

    protected void installDone(Task task, Throwable error) throws Exception {
        if (error != null) {
            log.error((Object)error);
            Assert.fail((String)"Unexpected Rollback on Install Task");
        }
    }

    protected void uninstallDone(Task task, Throwable error) throws Exception {
        if (error != null) {
            log.error((Object)error);
            Assert.fail((String)"Unexpected Rollback on uninstall Task");
        }
    }

    protected boolean validateInstall(Task task, ValidationStatus status) {
        if (status.hasErrors()) {
            Assert.fail((String)("Unexpected Validation Errors: " + status.getErrors()));
        }
        return true;
    }

    protected boolean validateUninstall(Task task, ValidationStatus status) {
        if (status.hasErrors()) {
            Assert.fail((String)("Unexpected Validation Errors: " + status.getErrors()));
        }
        return true;
    }

    protected File createPackage() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.name("nuxeo-automation").version("5.3.2").type(PackageType.ADDON);
        builder.platform("dm-5.3.2");
        builder.dependency("nuxeo-automation:5.3.2");
        builder.title("Test Package");
        builder.description("A test package");
        builder.classifier("Open Source");
        builder.vendor("Nuxeo");
        builder.addLicense("My test license. All rights reserved.");
        this.updatePackage(builder);
        XmlWriter writer = new XmlWriter();
        writer.start("install");
        writer.startContent();
        this.writeCommand(writer);
        writer.end("install");
        builder.addInstallScript(writer.toString());
        return builder.build();
    }

    protected Map<String, String> getUserProperties() {
        return new HashMap<String, String>();
    }

    public boolean install(LocalPackage pkg) throws Exception {
        ValidationStatus status;
        Map<String, String> props = this.getUserProperties();
        Task task = pkg.getInstallTask();
        if (!this.validateInstall(task, status = task.validate())) {
            return false;
        }
        Throwable error = null;
        try {
            task.run(props);
        }
        catch (Throwable t) {
            error = t;
            task.rollback();
        }
        this.installDone(task, error);
        return error == null;
    }

    public boolean uninstall(LocalPackage pkg) throws Exception {
        ValidationStatus status;
        Map<String, String> props = this.getUserProperties();
        Task task = pkg.getUninstallTask();
        if (!this.validateUninstall(task, status = task.validate())) {
            return false;
        }
        Throwable error = null;
        try {
            task.run(props);
        }
        catch (Throwable t) {
            error = t;
            task.rollback();
        }
        this.uninstallDone(task, error);
        return error == null;
    }

    @Test
    @ConditionalIgnoreRule.Ignore(condition=ConditionalIgnoreRule.IgnoreWindows.class, cause="NXP-9086")
    public void testInstallThenUninstall() throws Exception {
        File zip = this.createPackage();
        LocalPackage pkg = this.service.addPackage(zip);
        zip.delete();
        if (this.install(pkg)) {
            Assert.assertEquals((Object)PackageState.STARTED, (Object)pkg.getPackageState());
            if (this.uninstall(pkg)) {
                Assert.assertEquals((Object)PackageState.DOWNLOADED, (Object)pkg.getPackageState());
            }
        }
    }
}

