/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.nuxeo.common.Environment;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.standalone.commands.AbstractCommandTest;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.util.PackageBuilder;
import org.nuxeo.connect.update.xml.XmlWriter;
import org.nuxeo.runtime.api.Framework;

public class TestCopyDir
extends AbstractCommandTest {
    private static final String deprecatedFilename = "nuxeo-superfeature-5.4.2.jar";
    private static final String snapshotFilename = "nuxeo-otherfeature-5.5-SNAPSHOT.jar";
    private static final String newFilename = "nuxeo-superfeature-5.5.jar";
    private static final String notToDeployFilename = "nuxeo-newfeature-5.5.jar";
    private static final String testConfigFilename = "test-config.xml";
    private File deprecatedFile;
    private File snapshotFile;
    private File newFile;
    private File bundles;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.bundles = new File(Environment.getDefault().getHome(), "bundles");
        this.deprecatedFile = new File(this.bundles, deprecatedFilename);
        FileUtils.touch((File)this.deprecatedFile);
        this.newFile = new File(this.bundles, newFilename);
        this.snapshotFile = new File(this.bundles, snapshotFilename);
        org.nuxeo.common.utils.FileUtils.writeFile((File)this.snapshotFile, (String)"old SNAPSHOT content");
    }

    @Override
    protected void updatePackage(PackageBuilder builder) throws Exception {
        File jarFile = Framework.createTempFile((String)"test-commands-", (String)".jar");
        Framework.trackFile((File)jarFile, (Object)builder);
        org.nuxeo.common.utils.FileUtils.writeFile((File)jarFile, (String)"anything");
        builder.addEntry("bundles/nuxeo-superfeature-5.5.jar", (InputStream)new FileInputStream(jarFile));
        org.nuxeo.common.utils.FileUtils.writeFile((File)jarFile, (String)"new SNAPSHOT content");
        builder.addEntry("bundles/nuxeo-otherfeature-5.5-SNAPSHOT.jar", (InputStream)new FileInputStream(jarFile));
        builder.addEntry("bundles/nuxeo-newfeature-5.5.jar", (InputStream)new FileInputStream(jarFile));
        File xmlFile = Framework.createTempFile((String)"test-config", (String)".xml");
        Framework.trackFile((File)xmlFile, (Object)builder);
        org.nuxeo.common.utils.FileUtils.writeFile((File)xmlFile, (String)"anything");
        builder.addEntry("templates/collaboration/config/test-config.xml", (InputStream)new FileInputStream(xmlFile));
    }

    @Override
    protected void writeCommand(XmlWriter writer) {
        writer.start("copy");
        writer.attr("dir", "${package.root}/bundles");
        writer.attr("todir", "${env.bundles}");
        writer.attr("overwriteIfNewerVersion", "true");
        writer.attr("upgradeOnly", "true");
        writer.end();
        writer.start("copy");
        writer.attr("dir", "${package.root}/templates");
        writer.attr("todir", "${env.templates}");
        writer.attr("overwrite", "true");
        writer.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void installDone(Task task, Throwable error) throws Exception {
        super.installDone(task, error);
        LocalPackage pkg = task.getPackage();
        File src = pkg.getData().getEntry("bundles/nuxeo-superfeature-5.5.jar");
        Assert.assertTrue((String)"nuxeo-superfeature-5.5.jar was not installed", (boolean)this.newFile.isFile());
        Assert.assertEquals((Object)org.nuxeo.connect.update.util.IOUtils.createMd5((File)src), (Object)org.nuxeo.connect.update.util.IOUtils.createMd5((File)this.newFile));
        Assert.assertFalse((String)"nuxeo-superfeature-5.4.2.jar was not replaced", (boolean)this.deprecatedFile.exists());
        BufferedReader reader = new BufferedReader(new FileReader(this.snapshotFile));
        try {
            String line = reader.readLine();
            Assert.assertEquals((Object)"new SNAPSHOT content", (Object)line);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        Assert.assertFalse((String)"New feature was copied whereas 'upgradeOnly=true'", (boolean)new File(this.bundles, notToDeployFilename).exists());
        File templates = new File(Environment.getDefault().getHome(), "templates");
        File configFile = new File(templates, "collaboration/config/test-config.xml");
        Assert.assertTrue((boolean)configFile.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void uninstallDone(Task task, Throwable error) throws Exception {
        super.uninstallDone(task, error);
        Assert.assertFalse((String)"nuxeo-superfeature-5.5.jar was not removed", (boolean)this.newFile.exists());
        Assert.assertTrue((String)"nuxeo-superfeature-5.4.2.jar was not copy back", (boolean)this.deprecatedFile.exists());
        BufferedReader reader = new BufferedReader(new FileReader(this.snapshotFile));
        try {
            String line = reader.readLine();
            Assert.assertEquals((Object)"old SNAPSHOT content", (Object)line);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        File templates = new File(Environment.getDefault().getHome(), "templates");
        File configFile = new File(templates, "collaboration/config/test-config.xml");
        Assert.assertFalse((boolean)configFile.exists());
    }
}

