/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone.commands;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.connect.update.standalone.commands.AbstractCommandTest;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.util.PackageBuilder;
import org.nuxeo.connect.update.xml.XmlWriter;

public class TestPCopy
extends AbstractCommandTest {
    @Override
    protected void updatePackage(PackageBuilder builder) throws Exception {
        String content = "test=my ${v}";
        builder.addEntry("test.properties", (InputStream)new ByteArrayInputStream(content.getBytes()));
    }

    @Override
    protected void writeCommand(XmlWriter writer) {
        writer.start("pcopy");
        writer.attr("file", "${package.root}/test.properties");
        writer.attr("tofile", "${env.config}");
        writer.end();
    }

    @Override
    protected Map<String, String> getUserProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("v", "value");
        return map;
    }

    @Override
    protected void installDone(Task task, Throwable error) throws Exception {
        super.installDone(task, error);
        File dst = this.getTargetFile();
        Assert.assertTrue((boolean)dst.isFile());
        Assert.assertEquals((Object)"test=my value", (Object)FileUtils.readFile((File)dst));
    }

    @Override
    protected void uninstallDone(Task task, Throwable error) throws Exception {
        super.uninstallDone(task, error);
        Assert.assertFalse((boolean)this.getTargetFile().isFile());
    }

    protected File getTargetFile() {
        return new File(Environment.getDefault().getConfig(), "test.properties");
    }
}

