/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone.registry;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.connect.update.PackageDef;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.standalone.registry.SharedFilesTest;
import org.nuxeo.connect.update.task.update.Entry;
import org.nuxeo.connect.update.task.update.UpdateManager;
import org.nuxeo.connect.update.xml.XmlWriter;

public class TestRollback
extends SharedFilesTest {
    public static final String JARNAME = "some-jar";

    @Test
    public void testHotfixUninstall() throws Exception {
        String BASEFILENAME = "some-jar-5.6.jar";
        FileUtils.writeFile((File)new File(this.bundles, "some-jar-5.6.jar"), (String)"some-jar-5.6.jar");
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles("some-jar-5.6.jar");
        File bak = new File(mgr.getBackupRoot(), "bundles");
        if (bak.isDirectory()) {
            Assert.assertEquals((long)0L, (long)bak.list().length);
        }
        HotFixPackage1 hotfix1 = new HotFixPackage1();
        hotfix1.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        Entry entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertTrue((String)"Should have a base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix1.getFileName());
        hotfix1.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles("some-jar-5.6.jar");
        hotfix1.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix1.getFileName());
        HotFixPackage2 hotfix2 = new HotFixPackage2();
        hotfix2.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)2L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix2.getFileName());
        hotfix2.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix1.getFileName());
        hotfix1.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles("some-jar-5.6.jar");
    }

    @Test
    public void testUpgradeOnly1() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
        File bak = new File(mgr.getBackupRoot(), "bundles");
        if (bak.isDirectory()) {
            Assert.assertEquals((long)0L, (long)bak.list().length);
        }
        AddonPackage addon = new AddonPackage();
        addon.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        Entry entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertFalse((String)"Should have no base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(addon.getFileName());
        HotFixPackage2 hotfix2 = new HotFixPackage2();
        hotfix2.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)2L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix2.getFileName());
        hotfix2.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(addon.getFileName());
        addon.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
    }

    @Test
    public void testUpgradeOnly2() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
        File bak = new File(mgr.getBackupRoot(), "bundles");
        if (bak.isDirectory()) {
            Assert.assertEquals((long)0L, (long)bak.list().length);
        }
        AddonPackage addon = new AddonPackage();
        addon.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        Entry entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertFalse((String)"Should have no base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(addon.getFileName());
        HotFixPackage2 hotfix2 = new HotFixPackage2();
        hotfix2.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)2L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix2.getFileName());
        addon.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        Assert.assertNull((String)"Remaining version should be upgradeOnly", (Object)entry.getLastVersion(false));
        this.ensureFiles(new String[0]);
    }

    @Test
    public void testUpgradeOnly3() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
        File bak = new File(mgr.getBackupRoot(), "bundles");
        if (bak.isDirectory()) {
            Assert.assertEquals((long)0L, (long)bak.list().length);
        }
        HotFixPackage2 hotfix2 = new HotFixPackage2();
        hotfix2.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        Entry entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertFalse((String)"Should have no base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(new String[0]);
        AddonPackage addon = new AddonPackage();
        addon.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)2L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix2.getFileName());
        hotfix2.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(addon.getFileName());
        addon.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
    }

    @Test
    public void testUpgradeOnly4() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
        File bak = new File(mgr.getBackupRoot(), "bundles");
        if (bak.isDirectory()) {
            Assert.assertEquals((long)0L, (long)bak.list().length);
        }
        HotFixPackage2 hotfix2 = new HotFixPackage2();
        hotfix2.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        Entry entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertFalse((String)"Should have no base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(new String[0]);
        AddonPackage addon = new AddonPackage();
        addon.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)2L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix2.getFileName());
        addon.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        Assert.assertNull((String)"Remaining version should be upgradeOnly", (Object)entry.getLastVersion(false));
        this.ensureFiles(new String[0]);
    }

    @Test
    public void testUpgradeOnlyWithHotfixUninstall() throws Exception {
        UpdateManager mgr = this.getManager();
        Assert.assertEquals((long)0L, (long)mgr.getRegistry().size());
        this.ensureFiles(new String[0]);
        File bak = new File(mgr.getBackupRoot(), "bundles");
        if (bak.isDirectory()) {
            Assert.assertEquals((long)0L, (long)bak.list().length);
        }
        AddonPackage addon = new AddonPackage();
        addon.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        Entry entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertFalse((String)"Should have no base version", (boolean)entry.hasBaseVersion());
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        this.ensureFiles(addon.getFileName());
        HotFixPackage1 hotfix1 = new HotFixPackage1();
        hotfix1.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)2L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix1.getFileName());
        HotFixPackage2 hotfix2 = new HotFixPackage2();
        hotfix2.install();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)3L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix2.getFileName());
        hotfix2.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)2L, (long)entry.getVersions().size());
        this.ensureFiles(hotfix1.getFileName());
        addon.uninstall();
        mgr.load();
        Assert.assertEquals((String)"Registry size", (long)1L, (long)mgr.getRegistry().size());
        entry = (Entry)mgr.getRegistry().get("bundles/some-jar");
        Assert.assertNotNull((String)"Entry in registry", (Object)entry);
        Assert.assertEquals((String)"Nb versions in registry", (long)1L, (long)entry.getVersions().size());
        Assert.assertNull((String)"Remaining version should be upgradeOnly", (Object)entry.getLastVersion(false));
        this.ensureFiles(new String[0]);
    }

    public class HotFixPackage2
    extends HotFixPackage1 {
        @Override
        public String getFileName() {
            return "some-jar-5.6.0-HF02.jar";
        }

        public HotFixPackage2() throws Exception {
            super("5.6.0-HF02", "1.0.0", PackageType.HOT_FIX, TestRollback.this.service);
        }
    }

    public class HotFixPackage1
    extends AddonPackage {
        @Override
        public String getFileName() {
            return "some-jar-5.6.0-HF01.jar";
        }

        public HotFixPackage1() {
            super("5.6.0-HF01", "1.0.0", PackageType.HOT_FIX, TestRollback.this.service);
        }

        public HotFixPackage1(String name, String version, PackageType type, PackageUpdateService service) {
            super(name, version, type, service);
        }

        @Override
        protected void writeInstallCommands(XmlWriter writer) throws Exception {
            writer.start("update");
            writer.attr("file", "${package.root}/bundles");
            writer.attr("todir", "${env.bundles}");
            writer.attr("upgradeOnly", "true");
            writer.end();
        }
    }

    public class AddonPackage
    extends PackageDef {
        public String getFileName() {
            return "some-jar-5.6.jar";
        }

        public AddonPackage() {
            super("some-addon", "1.0.0", PackageType.ADDON, TestRollback.this.service);
        }

        public AddonPackage(String name, String version, PackageType type, PackageUpdateService service) {
            super(name, version, type, service);
        }

        @Override
        protected void writeInstallCommands(XmlWriter writer) throws Exception {
            writer.start("update");
            writer.attr("file", "${package.root}/bundles");
            writer.attr("todir", "${env.bundles}");
            writer.end();
        }

        @Override
        protected void updatePackage() throws Exception {
            this.addFile("bundles/" + this.getFileName(), this.getFileName());
        }
    }
}

