/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.tokenauth;

import javax.inject.Inject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.tokenauth.TokenAuthenticationJettyFeature;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeHarness;

@RunWith(value=FeaturesRunner.class)
@Features(value={TokenAuthenticationJettyFeature.class})
@Deploy(value={"org.nuxeo.ecm.platform.login.token.test:OSGI-INF/test-token-authentication-anonymous-contrib.xml"})
public class TestAnonymousTokenAuthenticationServlet {
    @Inject
    protected RuntimeHarness harness;
    @Inject
    protected TokenAuthenticationService tokenAuthenticationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServletAsAnonymous() throws Exception {
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = null;
        try {
            getMethod = new GetMethod("http://localhost:18080/authentication/token?applicationName=myFavoriteApp&deviceId=dead-beaf-cafe-babe&permission=rw");
            int status = httpClient.executeMethod((HttpMethod)getMethod);
            Assert.assertEquals((long)401L, (long)status);
            this.harness.deployContrib("org.nuxeo.ecm.platform.login.token.test", "OSGI-INF/test-token-authentication-allow-anonymous-token-contrib.xml");
            status = httpClient.executeMethod((HttpMethod)getMethod);
            Assert.assertEquals((long)201L, (long)status);
            String token = getMethod.getResponseBodyAsString();
            Assert.assertNotNull((Object)token);
            Assert.assertNotNull((Object)this.tokenAuthenticationService.getUserName(token));
            Assert.assertEquals((long)1L, (long)this.tokenAuthenticationService.getTokenBindings("Guest").size());
            this.harness.undeployContrib("org.nuxeo.ecm.platform.login.token.test", "OSGI-INF/test-token-authentication-allow-anonymous-token-contrib.xml");
        }
        finally {
            getMethod.releaseConnection();
        }
    }
}

